/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.discovery.MockDiscoveryListener;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.jcs3.utils.net.HostNameUtil;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class UDPDiscoveryUnitTest
extends TestCase {
    public void testSimpleUDPDiscoveryIPv4() throws IOException {
        if (HostNameUtil.getMulticastNetworkInterface() == null) {
            System.out.println("This machine does not support multicast");
            return;
        }
        this.simpleUDPDiscovery("228.5.6.7");
    }

    public void testSimpleUDPDiscoveryIPv6() throws IOException {
        if (HostNameUtil.getMulticastNetworkInterface() == null) {
            System.out.println("This machine does not support multicast");
            return;
        }
        this.simpleUDPDiscovery("FF02::5678");
    }

    private void simpleUDPDiscovery(String discoveryAddress) throws IOException {
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr(discoveryAddress);
        attributes.setUdpDiscoveryPort(6789);
        attributes.setServicePort(1000);
        attributes.setUdpTTL(4);
        UDPDiscoveryService service = new UDPDiscoveryService(attributes, (IElementSerializer)new StandardSerializer());
        service.startup();
        service.addParticipatingCacheName("testCache1");
        MockDiscoveryListener discoveryListener = new MockDiscoveryListener();
        service.addDiscoveryListener((IDiscoveryListener)discoveryListener);
        UDPDiscoveryReceiver receiver = new UDPDiscoveryReceiver(service, null, attributes.getUdpDiscoveryAddr(), attributes.getUdpDiscoveryPort());
        Thread t = new Thread((Runnable)receiver);
        t.start();
        try (UDPDiscoverySender sender = new UDPDiscoverySender(attributes, service.getSerializer());){
            int cnt;
            ArrayList<String> cacheNames = new ArrayList<String>();
            int numJunk = 10;
            for (int i = 0; i < 10; ++i) {
                cacheNames.add("junkCacheName" + i);
            }
            cacheNames.add("testCache1");
            int max = 10;
            try {
                for (cnt = 0; cnt < 10; ++cnt) {
                    sender.passiveBroadcast("localhost", 1111, cacheNames, 1L);
                    SleepUtil.sleepAtLeast(20L);
                }
            }
            catch (IOException e) {
                System.out.println("Problem sending multicast packet: " + e.getMessage());
            }
            SleepUtil.sleepAtLeast(200L);
            UDPDiscoveryUnitTest.assertTrue((String)("Receiver count [" + receiver.getCnt() + "] should be the at least the number sent [" + cnt + "]."), (cnt <= receiver.getCnt() ? 1 : 0) != 0);
        }
    }
}

