/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs3.engine.control.MockElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class TestRemoteCache
extends TestCase {
    private static final Log log = LogManager.getLog(TestRemoteCache.class);

    public TestRemoteCache() {
        try {
            System.out.println("main> creating registry on the localhost");
            RemoteUtils.createRegistry((int)1101);
            Properties config = RemoteUtils.loadProps((String)"/TestRemoteServer.ccf");
            RemoteCacheServerFactory.startup((String)"localhost", (int)1101, (Properties)config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestRemoteClient.ccf");
    }

    public void skiptestSimpleSend() throws Exception {
        log.info("testSimpleSend");
        CacheAccess cache = JCS.getInstance((String)"testCache");
        log.info("cache = " + cache);
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)("key" + i), (Object)("data" + i));
            log.info("put " + i);
        }
    }

    public void testService() throws Exception {
        Thread.sleep(100L);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        RemoteCacheAttributes rca = new RemoteCacheAttributes();
        rca.setRemoteLocation("localhost", 1101);
        rca.setCacheName("testCache");
        RemoteCacheFactory factory = new RemoteCacheFactory();
        factory.initialize();
        RemoteCacheManager mgr = factory.getManager((IRemoteCacheAttributes)rca, (ICompositeCacheManager)cacheMgr, (ICacheEventLogger)new MockCacheEventLogger(), (IElementSerializer)new MockElementSerializer());
        RemoteCacheNoWait cache = mgr.getCache((IRemoteCacheAttributes)rca);
        int numMes = 100;
        for (int i = 0; i < 100; ++i) {
            String message = "adsfasasfasfasdasf";
            CacheElement ce = new CacheElement("key1", (Object)("data" + i), (Object)"adsfasasfasfasdasf");
            cache.update((ICacheElement)ce);
        }
    }
}

