/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3;

import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.jcs3.log.LogManager;

public class TestLogConfigurationUtil {
    public static void configureLogger(StringWriter stringWriter, String loggerName) {
        LogManager.setLogSystem((String)"jul");
        java.util.logging.LogManager.getLogManager().reset();
        Logger rootLogger = java.util.logging.LogManager.getLogManager().getLogger("");
        rootLogger.addHandler(new MockLogHandler(stringWriter));
        rootLogger.setLevel(Level.FINE);
    }

    private static class MockLogHandler
    extends Handler {
        private final StringWriter writer;

        public MockLogHandler(StringWriter writer) {
            this.writer = writer;
        }

        @Override
        public void publish(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getMillis()).append(" - ").append(record.getSourceClassName()).append("#").append(record.getSourceMethodName()).append(" - ").append(record.getMessage()).append('\n');
            this.writer.append(sb.toString());
        }

        @Override
        public void flush() {
            this.writer.flush();
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

