/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class JMXs {
    private static final MBeanServer SERVER = JMXs.findMBeanServer();

    public static MBeanServer server() {
        return SERVER;
    }

    public static void register(ObjectName on, Object bean) {
        if (!SERVER.isRegistered(on)) {
            try {
                SERVER.registerMBean(bean, on);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static void unregister(ObjectName on) {
        if (SERVER.isRegistered(on)) {
            try {
                SERVER.unregisterMBean(on);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static MBeanServer findMBeanServer() {
        if (System.getProperty("javax.management.builder.initial") != null) {
            return MBeanServerFactory.createMBeanServer();
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    private JMXs() {
    }
}

