/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import org.apache.commons.io.input.BrokenReader;
import org.apache.commons.io.input.ClosedReader;
import org.apache.commons.io.input.UncheckedBufferedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UncheckedBufferedReaderTest {
    private UncheckedBufferedReader ucStringReader;
    private UncheckedBufferedReader ucBrokenReader;
    private IOException exception = new IOException("test exception");

    UncheckedBufferedReaderTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.ucStringReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)new StringReader("01"))).get();
        this.exception = new IOException("test exception");
        this.ucBrokenReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)new BrokenReader(this.exception))).get();
    }

    @Test
    void testBufferSize() {
        try (UncheckedBufferedReader uncheckedReader = ((UncheckedBufferedReader.Builder)((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)new StringReader("0123456789"))).setBufferSize(2)).get();){
            Assertions.assertEquals((int)48, (int)uncheckedReader.read());
        }
    }

    @Test
    void testClose() {
        this.ucStringReader.close();
        Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read());
    }

    @Test
    void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.close())).getCause());
    }

    @Test
    void testMarkReset() {
        this.ucStringReader.mark(10);
        int c = this.ucStringReader.read();
        this.ucStringReader.reset();
        Assertions.assertEquals((int)c, (int)this.ucStringReader.read());
    }

    @Test
    void testMarkThrows() {
        try (UncheckedBufferedReader closedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)ClosedReader.INSTANCE)).get();){
            closedReader.close();
            Assertions.assertThrows(UncheckedIOException.class, () -> closedReader.mark(1));
        }
    }

    @Test
    void testRead() {
        UncheckedBufferedReader reader = this.ucStringReader;
        try (UncheckedBufferedReader uncheckedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)reader)).get();){
            Assertions.assertEquals((int)48, (int)uncheckedReader.read());
            Assertions.assertEquals((int)49, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
        }
    }

    @Test
    void testReadCharArray() {
        UncheckedBufferedReader reader = this.ucStringReader;
        try (UncheckedBufferedReader uncheckedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)reader)).get();){
            char[] array = new char[1];
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((char)'0', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((char)'1', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)0, (int)array[0]);
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)0, (int)array[0]);
        }
    }

    @Test
    void testReadCharArrayIndexed() {
        UncheckedBufferedReader reader = this.ucStringReader;
        try (UncheckedBufferedReader uncheckedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)reader)).get();){
            char[] array = new char[1];
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((char)'0', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((char)'1', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)0, (int)array[0]);
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)0, (int)array[0]);
        }
    }

    @Test
    void testReadCharArrayIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read(new char[1], 0, 1))).getCause());
    }

    @Test
    void testReadCharArrayThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read(new char[1]))).getCause());
    }

    @Test
    void testReadCharBuffer() {
        UncheckedBufferedReader reader = this.ucStringReader;
        try (UncheckedBufferedReader uncheckedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)reader)).get();){
            CharBuffer buffer = CharBuffer.wrap(new char[1]);
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((char)'0', (char)buffer.charAt(0));
            buffer.put(0, '\u0000');
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((char)'1', (char)buffer.charAt(0));
            buffer.put(0, '\u0000');
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((int)0, (int)buffer.length());
            Assertions.assertEquals((int)0, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((int)0, (int)buffer.length());
        }
    }

    @Test
    void testReadCharBufferThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read(CharBuffer.wrap(new char[1])))).getCause());
    }

    @Test
    void testReadLine() {
        UncheckedBufferedReader reader = this.ucStringReader;
        try (UncheckedBufferedReader uncheckedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)reader)).get();){
            Assertions.assertEquals((Object)"01", (Object)uncheckedReader.readLine());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
        }
    }

    @Test
    void testReadLineThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.readLine())).getCause());
    }

    @Test
    void testReadThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read())).getCause());
    }

    @Test
    void testReady() {
        Assertions.assertTrue((boolean)this.ucStringReader.ready());
    }

    @Test
    void testReadyThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.ready())).getCause());
    }

    @Test
    void testResetThrows() {
        try (UncheckedBufferedReader closedReader = ((UncheckedBufferedReader.Builder)UncheckedBufferedReader.builder().setReader((Reader)ClosedReader.INSTANCE)).get();){
            closedReader.close();
            Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.reset());
        }
    }

    @Test
    void testSkip() {
        Assertions.assertEquals((long)1L, (long)this.ucStringReader.skip(1L));
    }

    @Test
    void testSkipThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.skip(1L))).getCause());
    }
}

