/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.util.Locale;
import org.apache.commons.beanutils2.locale.BaseLocaleConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractLocaleConverterTest<T> {
    protected Locale origLocale;
    protected BaseLocaleConverter<T> converter;
    protected Object result;
    protected T defaultValue;
    protected Object expectedValue;
    protected Locale localizedLocale;
    protected String localizedDecimalPattern;
    protected String localizedIntegerPattern;
    protected String localizedDecimalValue;
    protected String localizedIntegerValue;
    protected Locale defaultLocale;
    protected String defaultDecimalPattern;
    protected String defaultIntegerPattern;
    protected String defaultDecimalValue;
    protected String defaultIntegerValue;
    protected String expectedDecimalValue;
    protected String expectedIntegerValue;

    protected void convertInvalid(BaseLocaleConverter<T> converter, Object expectedValue) {
        this.convertInvalid(converter, "", expectedValue);
    }

    protected void convertInvalid(BaseLocaleConverter<T> converter, String msgId, Object expectedValue) {
        block4: {
            try {
                this.result = converter.convert((Object)"xyz");
                if (expectedValue == null) {
                    Assertions.fail((String)("Expected ConversionException if no default value " + msgId + ", converter = " + converter));
                }
            }
            catch (Exception e) {
                if (expectedValue == null) break block4;
                Assertions.fail((String)("Expected default value '" + msgId + "' threw " + e + ", expectedValue = '" + expectedValue + "'"));
            }
        }
        if (expectedValue != null) {
            Assertions.assertEquals((Object)expectedValue, (Object)this.result, () -> "Check invalid conversion is default " + msgId);
        }
    }

    protected void convertNull(BaseLocaleConverter<T> converter, Object expectedValue) {
        this.convertNull(converter, "", expectedValue);
    }

    protected void convertNull(BaseLocaleConverter<T> converter, String msgId, Object expectedValue) {
        this.result = Assertions.assertDoesNotThrow(() -> converter.convert(null), () -> "Null conversion threw '" + msgId + "'");
        if (expectedValue == null) {
            Assertions.assertNull((Object)this.result, () -> "Check null conversion is null '" + msgId + "' result=" + this.result);
        } else {
            Assertions.assertEquals((Object)expectedValue, (Object)this.result, () -> "Check null conversion is default " + msgId);
        }
    }

    protected void convertValueNoPattern(BaseLocaleConverter<T> converter, Object value, Object expectedValue) {
        this.convertValueNoPattern(converter, "", value, expectedValue);
    }

    protected void convertValueNoPattern(BaseLocaleConverter<T> converter, String msgId, Object value, Object expectedValue) {
        this.result = Assertions.assertDoesNotThrow(() -> converter.convert(value), () -> "No Pattern conversion threw '" + msgId + "'");
        Assertions.assertEquals((Object)expectedValue, (Object)this.result, () -> "Check conversion value without pattern " + msgId);
    }

    protected void convertValueWithPattern(BaseLocaleConverter<T> converter, Object value, String pattern, Object expectedValue) {
        this.convertValueWithPattern(converter, "", value, pattern, expectedValue);
    }

    protected void convertValueWithPattern(BaseLocaleConverter<T> converter, String msgId, Object value, String pattern, Object expectedValue) {
        this.result = Assertions.assertDoesNotThrow(() -> converter.convert(value, pattern), () -> "Pattern conversion threw '" + msgId + "'");
        Assertions.assertEquals((Object)expectedValue, (Object)this.result, () -> "Check conversion value with pattern " + msgId);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.defaultLocale = Locale.US;
        this.defaultDecimalPattern = "#,###.00";
        this.defaultIntegerPattern = "#,###";
        this.defaultDecimalValue = "1,234.56";
        this.defaultIntegerValue = "1,234";
        this.localizedLocale = Locale.GERMAN;
        this.localizedDecimalPattern = "#.###,00";
        this.localizedIntegerPattern = "#.###";
        this.localizedDecimalValue = "1.234,56";
        this.localizedIntegerValue = "1.234";
        this.expectedDecimalValue = "1234.56";
        this.expectedIntegerValue = "1234";
        this.origLocale = Locale.getDefault();
        this.converter = null;
        this.result = null;
        this.defaultValue = null;
        this.expectedValue = null;
        if (this.defaultLocale.equals(this.origLocale)) {
            this.origLocale = null;
        } else {
            Locale.setDefault(this.defaultLocale);
        }
    }

    @AfterEach
    public void tearDown() {
        this.converter = null;
        this.result = null;
        this.defaultValue = null;
        this.expectedValue = null;
        if (this.origLocale != null) {
            Locale.setDefault(this.origLocale);
        }
    }
}

