/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.DeleteRuleUpdater;

public class CreateRelationshipAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Relationship";
    }

    public CreateRelationshipAction(Application application) {
        super(CreateRelationshipAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-relationship.gif";
    }

    public void performAction(ActionEvent e) {
        ObjEntity objEnt = this.getProjectController().getCurrentObjEntity();
        if (objEnt != null) {
            ObjRelationship rel = (ObjRelationship)NamedObjectFactory.createObject(ObjRelationship.class, objEnt);
            this.createObjRelationship(objEnt, rel);
            this.application.getUndoManager().addEdit(new CreateRelationshipUndoableEdit(objEnt, new ObjRelationship[]{rel}));
        } else {
            DbEntity dbEnt = this.getProjectController().getCurrentDbEntity();
            if (dbEnt != null) {
                DbRelationship rel = (DbRelationship)NamedObjectFactory.createObject(DbRelationship.class, dbEnt);
                this.createDbRelationship(dbEnt, rel);
                this.application.getUndoManager().addEdit(new CreateRelationshipUndoableEdit(dbEnt, new DbRelationship[]{rel}));
            }
        }
    }

    public void createObjRelationship(ObjEntity objEntity, ObjRelationship rel) {
        ProjectController mediator = this.getProjectController();
        rel.setSourceEntity(objEntity);
        DeleteRuleUpdater.updateObjRelationship(rel);
        objEntity.addRelationship(rel);
        CreateRelationshipAction.fireObjRelationshipEvent(this, mediator, objEntity, rel);
    }

    static void fireObjRelationshipEvent(Object src, ProjectController mediator, ObjEntity objEntity, ObjRelationship rel) {
        mediator.fireObjRelationshipEvent(new RelationshipEvent(src, (Relationship)rel, (Entity)objEntity, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, rel, (Entity)objEntity, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain());
        mediator.fireObjRelationshipDisplayEvent(rde);
    }

    public void createDbRelationship(DbEntity dbEntity, DbRelationship rel) {
        ProjectController mediator = this.getProjectController();
        rel.setSourceEntity(dbEntity);
        dbEntity.addRelationship(rel);
        CreateRelationshipAction.fireDbRelationshipEvent(this, mediator, dbEntity, rel);
    }

    static void fireDbRelationshipEvent(Object src, ProjectController mediator, DbEntity dbEntity, DbRelationship rel) {
        mediator.fireDbRelationshipEvent(new RelationshipEvent(src, (Relationship)rel, (Entity)dbEntity, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, rel, (Entity)dbEntity, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain());
        mediator.fireDbRelationshipDisplayEvent(rde);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(Entity.class) != null;
    }
}

