/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.util.WebApplicationResourceLocator;

public class ServletUtil {
    public static final String CONFIGURATION_PATH_KEY = "cayenne.configuration.path";
    public static final String DATA_CONTEXT_KEY = "cayenne.datacontext";

    public static synchronized Configuration initializeSharedConfiguration(ServletContext context) {
        ResourceFinder locator;
        Configuration oldConfig = Configuration.sharedConfiguration;
        if (oldConfig instanceof DefaultConfiguration && (locator = oldConfig.getResourceFinder()) instanceof WebApplicationResourceLocator && ((WebApplicationResourceLocator)locator).getServletContext() == context) {
            return oldConfig;
        }
        DefaultConfiguration conf = new DefaultConfiguration("cayenne.xml", ServletUtil.createLocator(context));
        Configuration.initializeSharedConfiguration(conf);
        return conf;
    }

    protected static ResourceLocator createLocator(ServletContext context) {
        WebApplicationResourceLocator locator = new WebApplicationResourceLocator();
        locator.setSkipAbsolutePath(true);
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(true);
        locator.setSkipHomeDirectory(true);
        locator.setServletContext(context);
        String configurationPath = context.getInitParameter(CONFIGURATION_PATH_KEY);
        if (configurationPath != null && configurationPath.trim().length() > 0) {
            locator.addFilesystemPath(configurationPath.trim());
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataContext getSessionContext(HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            DataContext ctxt = (DataContext)session.getAttribute(DATA_CONTEXT_KEY);
            if (ctxt == null) {
                ctxt = DataContext.createDataContext();
                session.setAttribute(DATA_CONTEXT_KEY, (Object)ctxt);
            }
            return ctxt;
        }
    }
}

