/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.crypto.transformer.bytes.Header;

abstract class HmacCreator {
    public static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA256";
    private Header header;
    private Mac mac;

    HmacCreator(Header header, Key key) {
        this.header = header;
        try {
            this.mac = Mac.getInstance(DEFAULT_HMAC_ALGORITHM);
            this.mac.init(key);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CayenneRuntimeException("Algorithm %s not supported for HMAC generation", (Throwable)nsae, new Object[]{DEFAULT_HMAC_ALGORITHM});
        }
        catch (InvalidKeyException ike) {
            throw new CayenneRuntimeException("Invalid key for HMAC generation", (Throwable)ike, new Object[0]);
        }
    }

    byte[] createHmac(byte[] input) {
        byte[] rawHeader = new byte[this.header.size()];
        this.header.store(rawHeader, 0, this.header.getFlags());
        this.mac.update(rawHeader);
        return this.mac.doFinal(input);
    }
}

