/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.Util;

public abstract class PatternMatchNode
extends ConditionNode {
    protected transient Pattern pattern;
    protected transient boolean patternCompiled;
    protected boolean ignoringCase;
    protected char escapeChar;

    PatternMatchNode(int i, boolean ignoringCase) {
        super(i);
        this.ignoringCase = ignoringCase;
    }

    PatternMatchNode(int i, boolean ignoringCase, char escapeChar) {
        super(i);
        this.ignoringCase = ignoringCase;
        this.setEscapeChar(escapeChar);
    }

    SimpleNode wrap(Object pattern) {
        if (pattern instanceof SimpleNode) {
            return (SimpleNode)pattern;
        }
        return new ASTScalar(pattern);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char value) {
        if ('?' == value) {
            throw new CayenneRuntimeException("the use of the '?' as an escape character in LIKE clauses is disallowed.", new Object[0]);
        }
        this.escapeChar = value;
    }

    public boolean isIgnoringCase() {
        return this.ignoringCase;
    }

    protected boolean matchPattern(String string) {
        return string != null && this.getPattern().matcher(string).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern getPattern() {
        if (!this.patternCompiled) {
            PatternMatchNode patternMatchNode = this;
            synchronized (patternMatchNode) {
                if (!this.patternCompiled) {
                    this.pattern = null;
                    if (this.jjtGetNumChildren() < 2) {
                        this.patternCompiled = true;
                        return null;
                    }
                    Node node = this.jjtGetChild(1);
                    if (node instanceof ASTScalar) {
                        ASTScalar patternNode = (ASTScalar)node;
                        if (patternNode == null) {
                            this.patternCompiled = true;
                            return null;
                        }
                        String srcPattern = (String)patternNode.getValue();
                        if (srcPattern == null) {
                            this.patternCompiled = true;
                            return null;
                        }
                        this.pattern = Util.sqlPatternToPattern(srcPattern, this.ignoringCase);
                        this.patternCompiled = true;
                    }
                }
            }
        }
        return this.pattern;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (i == 1) {
            this.patternCompiled = false;
        }
        super.jjtAddChild(n, i);
    }

    @Override
    protected void appendChildrenAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        super.appendChildrenAsEJBQL(parameterAccumulator, out, rootId);
        if ('\u0000' != this.getEscapeChar()) {
            if ('\'' == this.getEscapeChar()) {
                throw new CayenneRuntimeException("unable to escape an EJBQL like clause with a single quote character", new Object[0]);
            }
            out.append(" escape '");
            out.append(this.getEscapeChar());
            out.append("'");
        }
    }
}

