/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Writer;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.editor.cgen.CgenConfigController;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.ArtefactsConfigurator;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.DataMapArtefactsConfigurator;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.EditorTemplateLoader;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.EditorTemplateSaver;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.EmbeddableArtefactsConfigurator;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.EntityArtefactsConfigurator;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.FindAndReplaceController;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.FindController;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.PreviewActionConfigurator;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.velocity.exception.ParseErrorException;

public class TemplateEditorController
extends CayenneController {
    private final DataMap currentDataMap;
    private final CgenConfiguration configuration;
    private final CgenConfigController parentController;
    private final TemplateType templateType;
    private EditorTemplateLoader templateLoader;
    private EditorTemplateSaver templateSaver;
    private Boolean isTemplateModified;
    private Boolean isTemplateDefault;
    private ArtefactsConfigurator artefactsConfigurator;
    private TemplateEditorView editorView;
    private PreviewActionConfigurator actionConfigurator;

    public TemplateEditorController(CgenConfigController parentController, TemplateType templateType) {
        super(parentController.getCodeGeneratorController());
        this.templateType = templateType;
        this.configuration = parentController.getCodeGeneratorController().getCgenConfiguration();
        this.currentDataMap = this.configuration.getDataMap();
        this.parentController = parentController;
    }

    public void startupAction() {
        this.artefactsConfigurator = this.setupArtefactConfigurator();
        this.editorView = new TemplateEditorView(this.artefactsConfigurator.getArtifactsNames(this.currentDataMap));
        this.actionConfigurator = new PreviewActionConfigurator(this);
        this.isTemplateDefault = TemplateType.isDefault(this.configuration.getTemplateByType(this.templateType).getData());
        this.isTemplateModified = false;
        this.templateLoader = new EditorTemplateLoader(this.configuration, this.editorView);
        this.templateSaver = new EditorTemplateSaver(this.configuration);
        this.configureEditorView(this.templateType);
        this.addListeners();
        this.centerView();
        this.initBindings();
        this.editorView.setVisible(true);
    }

    private ArtefactsConfigurator setupArtefactConfigurator() {
        switch (this.templateType) {
            case ENTITY_SUPERCLASS: 
            case ENTITY_SUBCLASS: {
                return new EntityArtefactsConfigurator();
            }
            case EMBEDDABLE_SUPERCLASS: 
            case EMBEDDABLE_SUBCLASS: {
                return new EmbeddableArtefactsConfigurator();
            }
            case DATAMAP_SUPERCLASS: 
            case DATAMAP_SUBCLASS: {
                return new DataMapArtefactsConfigurator();
            }
        }
        throw new IllegalStateException("Illegal template type " + String.valueOf((Object)this.templateType));
    }

    private void configureEditorView(TemplateType templateType) {
        this.editorView.getEditingTemplatePane().setText(this.templateLoader.load(templateType, this.isTemplateDefault));
        this.editorView.getEditingTemplatePane().discardAllEdits();
        this.editorView.editingTemplatePane.setCaretPosition(0);
        this.editorView.getSaveButton().setEnabled(this.isTemplateModified);
        this.editorView.setTitle(templateType.readableName() + " - cayenne template editor");
    }

    @Override
    public TemplateEditorView getView() {
        return this.editorView;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.editorView.getSaveButton(), "saveAction()");
        builder.bindToAction(this.editorView.getPreviewButton(), "generatePreviewAction()");
        builder.bindToAction(this.editorView.getFindButton(), "findAction()");
        builder.bindToAction(this.editorView.getFindAndReplaceButton(), "findAndReplaceAction()");
        builder.bindToAction(this.editorView.getResetToDefaultButton(), "resetToDefaultAction()");
    }

    protected void addListeners() {
        this.editorView.getEditingTemplatePane().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TemplateEditorController.this.isTemplateModified = true;
                TemplateEditorController.this.isTemplateDefault = false;
                TemplateEditorController.this.editorView.getSaveButton().setEnabled(true);
            }
        });
        this.editorView.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TemplateEditorController.this.parentController.setEditorOpen(true);
                TemplateEditorController.this.parentController.updateTemplateEditorButtons();
            }
        });
        this.editorView.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TemplateEditorController.this.isTemplateModified.booleanValue() && TemplateEditorController.this.showUnsavedChangesCloseDialog() == 0) {
                    TemplateEditorController.this.saveAction();
                }
                TemplateEditorController.this.parentController.setEditorOpen(false);
                TemplateEditorController.this.parentController.updateTemplateEditorButtons();
            }
        });
    }

    public void saveAction() {
        this.templateSaver.save(this.templateType, this.isTemplateDefault, this.editorView.getTemplateText());
        this.parentController.getCodeGeneratorController().checkCgenConfigDirty();
        this.isTemplateModified = false;
        this.parentController.updateTemplatesLabels(this.configuration);
        this.editorView.getSaveButton().setEnabled(false);
    }

    public void generatePreviewAction() throws Exception {
        ClassGenerationAction action = this.actionConfigurator.preparePreviewAction(this.editorView.getTemplateText());
        Writer writer = this.actionConfigurator.getWriter();
        int caretPosition = this.editorView.getEditingTemplatePane().getCaretPosition();
        try {
            action.execute();
        }
        catch (ParseErrorException pe) {
            caretPosition = this.getErrorCaretPosition(pe);
            writer.write(pe.getMessage());
        }
        catch (Exception e) {
            writer.write(e.getMessage());
        }
        this.displayPreview(writer, caretPosition);
    }

    private void displayPreview(Writer writer, int caretPosition) {
        this.editorView.getEditingTemplatePane().setCaretPosition(caretPosition);
        this.editorView.getClassPreviewPane().setText(null);
        this.editorView.getClassPreviewPane().setText(writer.toString());
        this.editorView.getClassPreviewPane().setCaretPosition(0);
    }

    private int getErrorCaretPosition(ParseErrorException e) throws BadLocationException {
        int errorLineNumber = e.getLineNumber();
        return this.editorView.getEditingTemplatePane().getLineStartOffset(errorLineNumber - 1);
    }

    public void findAction() {
        new FindController(this).startupAction();
    }

    public void findAndReplaceAction() {
        new FindAndReplaceController(this).startupAction();
    }

    public void resetToDefaultAction() {
        int result = this.showResetToDefaultDialog();
        if (result == 0) {
            this.editorView.getEditingTemplatePane().setText(this.templateLoader.load(this.templateType, true));
            this.editorView.getEditingTemplatePane().setCaretPosition(0);
            this.isTemplateModified = true;
            this.isTemplateDefault = true;
        }
    }

    private int showResetToDefaultDialog() {
        Object[] options = new Object[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(null, "This action will be rollback template to default.\n            This action can't be revert. \n                   Are you sure?", "Reset template to default", 0, 3, null, options, options[1]);
    }

    private int showUnsavedChangesCloseDialog() {
        Object[] options = new Object[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(null, "The are unsaved changes in template\n    Do you want to save it? ", "Unsaved changes", 0, 3, null, options, options[0]);
    }

    public DataMap getCurrentDataMap() {
        return this.currentDataMap;
    }

    public CgenConfiguration getConfiguration() {
        return this.configuration;
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public ArtefactsConfigurator getArtefactsConfigurator() {
        return this.artefactsConfigurator;
    }

    public String getSelectedArtifactName() {
        return this.getView().getSelectedArtifactName();
    }
}

