/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.PrefetchModel;
import org.apache.cayenne.modeler.undo.AddPrefetchUndoableEditForSqlTemplate;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;
import org.apache.cayenne.util.CayenneMapEntry;

public class SQLTemplatePrefetchTab
extends JPanel
implements PropertyChangeListener {
    private static final String SPLIT_DIVIDER_LOCATION_PROPERTY = "query.orderings.divider.location";
    private static final Dimension BROWSER_CELL_DIM = new Dimension(150, 100);
    private static final Dimension TABLE_DIM = new Dimension(460, 60);
    private static final String REAL_PANEL = "real";
    private static final String PLACEHOLDER_PANEL = "placeholder";
    protected ProjectController mediator;
    protected SQLTemplateDescriptor sqlTemplate;
    protected MultiColumnBrowser browser;
    protected JTable table;
    protected CardLayout cardLayout;
    protected JPanel messagePanel;

    public SQLTemplatePrefetchTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.messagePanel = new JPanel(new BorderLayout());
        this.cardLayout = new CardLayout();
        Preferences detail = Application.getInstance().getPreferencesNode(this.getClass(), "");
        int defLocation = Application.getFrame().getHeight() / 2;
        int location = detail != null ? detail.getInt(this.getDividerLocationProperty(), defLocation) : defLocation;
        JSplitPane mainPanel = new JSplitPane(0);
        mainPanel.addPropertyChangeListener("dividerLocation", this);
        mainPanel.setDividerLocation(location);
        mainPanel.setTopComponent(this.createEditorPanel());
        mainPanel.setBottomComponent(this.createSelectorPanel());
        this.setLayout(this.cardLayout);
        this.add((Component)mainPanel, REAL_PANEL);
        this.add((Component)this.messagePanel, PLACEHOLDER_PANEL);
    }

    protected void initController() {
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                UIUtil.scrollToSelectedRow(this.table);
            }
        });
    }

    protected void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"SQLTemplate".equals(query.getType())) {
            this.processInvalidModel("Unknown query.");
            return;
        }
        if (!(query.getRoot() instanceof Entity)) {
            this.processInvalidModel("SQLTemplate has no root set.");
            return;
        }
        this.sqlTemplate = (SQLTemplateDescriptor)query;
        this.browser.setModel(this.createBrowserModel((Entity)this.sqlTemplate.getRoot()));
        this.table.setModel(this.createTableModel());
        this.setUpPrefetchBox(this.table.getColumnModel().getColumn(2));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.cardLayout.show(this, REAL_PANEL);
    }

    protected void processInvalidModel(String message) {
        JLabel messageLabel = new JLabel(message, 0);
        this.messagePanel.removeAll();
        this.messagePanel.add((Component)messageLabel, "Center");
        this.cardLayout.show(this, PLACEHOLDER_PANEL);
    }

    protected void setUpPrefetchBox(TableColumn column) {
        JComboBox<String> prefetchBox = new JComboBox<String>();
        prefetchBox.addItem("Joint");
        prefetchBox.addItem("Disjoint by id");
        prefetchBox.addActionListener(e -> Application.getInstance().getFrameController().getEditorView().getEventController().setDirty(true));
        column.setCellEditor(new DefaultCellEditor(prefetchBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        column.setCellRenderer(renderer);
    }

    protected JPanel createEditorPanel() {
        this.table = new JTable();
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.table.setPreferredScrollableViewportSize(TABLE_DIM);
        this.table.setSelectionMode(0);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.table), "Center");
        return panel;
    }

    protected JPanel createSelectorPanel() {
        this.browser = new MultiColumnBrowser();
        this.browser.setPreferredColumnSize(BROWSER_CELL_DIM);
        this.browser.setDefaultRenderer();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createToolbar(), "North");
        panel.add((Component)new JScrollPane(this.browser, 21, 30), "Center");
        panel.setMinimumSize(panel.getPreferredSize());
        return panel;
    }

    protected JComponent createToolbar() {
        CayenneAction.CayenneToolbarButton add = new CayenneAction.CayenneToolbarButton(null, 1);
        ((AbstractButton)add).setText("Add Prefetch");
        ImageIcon addIcon = ModelerUtil.buildIcon("icon-plus.png");
        add.setIcon(addIcon);
        add.setDisabledIcon(FilteredIconFactory.createDisabledIcon(addIcon));
        add.addActionListener(e -> {
            String prefetch = this.getSelectedPath();
            if (prefetch == null) {
                return;
            }
            this.addPrefetch(prefetch);
            Application.getInstance().getUndoManager().addEdit(new AddPrefetchUndoableEditForSqlTemplate(prefetch, this));
        });
        CayenneAction.CayenneToolbarButton remove = new CayenneAction.CayenneToolbarButton(null, 3);
        ((AbstractButton)remove).setText("Remove Prefetch");
        ImageIcon removeIcon = ModelerUtil.buildIcon("icon-trash.png");
        remove.setIcon(removeIcon);
        remove.setDisabledIcon(FilteredIconFactory.createDisabledIcon(removeIcon));
        remove.addActionListener(e -> {
            int selection = this.table.getSelectedRow();
            if (selection < 0) {
                return;
            }
            String prefetch = (String)this.table.getModel().getValueAt(selection, 0);
            this.removePrefetch(prefetch);
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEmptyBorder());
        toolBar.setFloatable(false);
        toolBar.add(add);
        toolBar.add(remove);
        return toolBar;
    }

    protected String getSelectedPath() {
        Object[] path = this.browser.getSelectionPath().getPath();
        if (path.length < 2) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        CayenneMapEntry first = (CayenneMapEntry)path[1];
        buffer.append(first.getName());
        for (int i = 2; i < path.length; ++i) {
            CayenneMapEntry pathEntry = (CayenneMapEntry)path[i];
            buffer.append(".").append(pathEntry.getName());
        }
        return buffer.toString();
    }

    protected TreeModel createBrowserModel(Entity<?, ?, ?> entity) {
        EntityTreeModel treeModel = new EntityTreeModel(entity);
        treeModel.setFilter(new EntityTreeFilter(){

            @Override
            public boolean attributeMatch(Object node, Attribute<?, ?, ?> attr) {
                return false;
            }

            @Override
            public boolean relationshipMatch(Object node, Relationship<?, ?, ?> rel) {
                return true;
            }
        });
        return treeModel;
    }

    protected TableModel createTableModel() {
        return new PrefetchModel(this.sqlTemplate.getPrefetchesMap(), this.sqlTemplate.getRoot());
    }

    public void addPrefetch(String prefetch) {
        if (!this.sqlTemplate.getPrefetchesMap().isEmpty() && this.sqlTemplate.getPrefetchesMap().containsKey(prefetch)) {
            return;
        }
        this.sqlTemplate.addPrefetch(prefetch, PrefetchModel.getPrefetchType("Disjoint by id"));
        this.table.setModel(this.createTableModel());
        this.setUpPrefetchBox(this.table.getColumnModel().getColumn(2));
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.sqlTemplate));
    }

    public void removePrefetch(String prefetch) {
        this.sqlTemplate.removePrefetch(prefetch);
        this.table.setModel(this.createTableModel());
        this.setUpPrefetchBox(this.table.getColumnModel().getColumn(2));
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.sqlTemplate));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("dividerLocation".equals(evt.getPropertyName())) {
            int value = (Integer)evt.getNewValue();
            Preferences detail = Application.getInstance().getPreferencesNode(this.getClass(), "");
            detail.putInt(this.getDividerLocationProperty(), value);
        }
    }

    protected String getDividerLocationProperty() {
        return SPLIT_DIVIDER_LOCATION_PROPERTY;
    }
}

