/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.cayenne.access.types.ExtendedType;

public class TimestampType
implements ExtendedType<Timestamp> {
    private final Calendar calendar;
    private final boolean useCalendar;

    public TimestampType() {
        this(false);
    }

    public TimestampType(boolean useCalendar) {
        this.useCalendar = useCalendar;
        this.calendar = this.useCalendar ? Calendar.getInstance() : null;
    }

    @Override
    public String getClassName() {
        return Timestamp.class.getName();
    }

    @Override
    public Timestamp materializeObject(ResultSet rs, int index, int type) throws Exception {
        return this.useCalendar ? rs.getTimestamp(index, this.calendar) : rs.getTimestamp(index);
    }

    @Override
    public Timestamp materializeObject(CallableStatement cs, int index, int type) throws Exception {
        return this.useCalendar ? cs.getTimestamp(index, this.calendar) : cs.getTimestamp(index);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Timestamp value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (this.useCalendar) {
            statement.setTimestamp(pos, value, this.calendar);
        } else {
            statement.setTimestamp(pos, value);
        }
    }

    @Override
    public String toString(Timestamp value) {
        if (value == null) {
            return "NULL";
        }
        return "'" + value.toString() + "'";
    }
}

