/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.Options;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

final class PlasticFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean isKeyboardFocusEvent = true;

    PlasticFieldCaret() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        JTextComponent c = this.getComponent();
        if (c == null) {
            return;
        }
        if (c.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (!(c.isEnabled() && this.isKeyboardFocusEvent && Options.isSelectOnFocusGainActive(c))) {
            return;
        }
        if (c instanceof JFormattedTextField) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlasticFieldCaret.this.selectAll();
                }
            });
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        JTextComponent c = this.getComponent();
        if (c == null) {
            return;
        }
        boolean backward = Boolean.TRUE.equals(c.getClientProperty("JGoodies.invertSelection"));
        if (backward) {
            this.setDot(c.getDocument().getLength());
            this.moveDot(0);
        } else {
            this.setDot(0);
            this.moveDot(c.getDocument().getLength());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary()) {
            this.isKeyboardFocusEvent = true;
            if (this.getComponent() != null && Boolean.TRUE.equals(this.getComponent().getClientProperty("JGoodies.setCaretToStartOnFocusLost"))) {
                this.setDot(0);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) || e.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

