package org.apache.cayenne.testdo.compound.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.GenericPersistentObject;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.testdo.compound.CompoundOrder;
import org.apache.cayenne.testdo.compound.CompoundOrderLine;
import org.apache.cayenne.testdo.compound.CompoundOrderLineInfo;

/**
 * Class _CompoundOrderLine was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _CompoundOrderLine extends GenericPersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<CompoundOrderLine> SELF = PropertyFactory.createSelf(CompoundOrderLine.class);

    public static final String ORDER_LINE_NUMBER_PK_COLUMN = "order_line_number";
    public static final NumericIdProperty<Integer> ORDER_NUMBER_PK_PROPERTY = PropertyFactory.createNumericId("order_number", "CompoundOrderLine", Integer.class);
    public static final String ORDER_NUMBER_PK_COLUMN = "order_number";

    public static final NumericProperty<Integer> LINE_NUMBER = PropertyFactory.createNumeric("lineNumber", Integer.class);
    public static final EntityProperty<CompoundOrderLineInfo> INFO = PropertyFactory.createEntity("info", CompoundOrderLineInfo.class);
    public static final EntityProperty<CompoundOrder> ORDER = PropertyFactory.createEntity("order", CompoundOrder.class);

    protected int lineNumber;

    protected Object info;
    protected Object order;

    public void setLineNumber(int lineNumber) {
        beforePropertyWrite("lineNumber", this.lineNumber, lineNumber);
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        beforePropertyRead("lineNumber");
        return this.lineNumber;
    }

    public void setInfo(CompoundOrderLineInfo info) {
        setToOneTarget("info", info, true);
    }

    public CompoundOrderLineInfo getInfo() {
        return (CompoundOrderLineInfo)readProperty("info");
    }

    public void setOrder(CompoundOrder order) {
        setToOneTarget("order", order, true);
    }

    public CompoundOrder getOrder() {
        return (CompoundOrder)readProperty("order");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "lineNumber":
                return this.lineNumber;
            case "info":
                return this.info;
            case "order":
                return this.order;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "lineNumber":
                this.lineNumber = val == null ? 0 : (int)val;
                break;
            case "info":
                this.info = val;
                break;
            case "order":
                this.order = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeInt(this.lineNumber);
        out.writeObject(this.info);
        out.writeObject(this.order);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.lineNumber = in.readInt();
        this.info = in.readObject();
        this.order = in.readObject();
    }

}
