/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/
package org.apache.cayenne.unit.di.server;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.test.jdbc.DBHelper;

public class FlavoredDBHelperProvider implements Provider<DBHelper> {

    @Inject
    protected ServerCaseDataSourceFactory dataSourceFactory;

    @Inject
    // injecting provider to make this provider independent from scoping of
    // ServerRuntime
    protected Provider<ServerRuntime> serverRuntimeProvider;

    @Inject
    protected DbAdapter adapter;

    public DBHelper get() throws ConfigurationException {
        DataChannel channel = serverRuntimeProvider.get().getChannel();
        DataMap firstMap = channel.getEntityResolver().getDataMaps().iterator().next();
        return new FlavoredDBHelper(dataSourceFactory.getSharedDataSource(), adapter.getQuotingStrategy(), firstMap);
    }
}
