/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.AbstractCallbackMethodsTab;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.event.EntityListenerListener;
import org.apache.cayenne.modeler.util.CayenneAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCallbackListenersTab
extends AbstractCallbackMethodsTab {
    protected JComboBox listenerClassCombo;

    protected AbstractCallbackListenersTab(ProjectController mediator) {
        super(mediator);
    }

    protected abstract List<EntityListener> getEntityListeners();

    protected abstract CayenneAction getRemoveEntityListenerAction();

    public abstract CayenneAction getCreateEntityListenerAction();

    @Override
    protected void init() {
        super.init();
        this.toolBar.addSeparator();
        this.toolBar.add(this.getCreateEntityListenerAction().buildButton());
        this.toolBar.add(this.getRemoveEntityListenerAction().buildButton());
    }

    protected abstract EntityListener getEntityListener(String var1);

    private void processEditedListenerClassValue(String newValue) {
        EntityListener listener;
        String prevName = this.mediator.getCurrentListenerClass();
        if (this.getEntityListener(newValue) == null && (listener = this.getEntityListener(prevName)) != null) {
            listener.setClassName(newValue);
            this.mediator.fireEntityListenerEvent(new EntityListenerEvent(this, prevName, newValue, 1));
        }
    }

    @Override
    protected void initController() {
        super.initController();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                AbstractCallbackListenersTab.this.rebuildListenerClassCombo(null);
                AbstractCallbackListenersTab.this.mediator.setCurrentCallbackType((CallbackType)AbstractCallbackListenersTab.this.callbackTypeCombo.getSelectedItem());
                AbstractCallbackListenersTab.this.updateCallbackTypeCounters();
                AbstractCallbackListenersTab.this.rebuildTable();
            }
        });
        this.listenerClassCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && AbstractCallbackListenersTab.this.isVisible()) {
                    if (AbstractCallbackListenersTab.this.listenerClassCombo.getSelectedIndex() == -1 && AbstractCallbackListenersTab.this.listenerClassCombo.getSelectedItem() != null) {
                        AbstractCallbackListenersTab.this.processEditedListenerClassValue((String)AbstractCallbackListenersTab.this.listenerClassCombo.getSelectedItem());
                    } else {
                        AbstractCallbackListenersTab.this.mediator.setCurrentListenerClass((String)AbstractCallbackListenersTab.this.listenerClassCombo.getSelectedItem());
                        AbstractCallbackListenersTab.this.updateCallbackTypeCounters();
                        AbstractCallbackListenersTab.this.rebuildTable();
                    }
                }
            }
        });
        this.mediator.addEntityListenerListener(new EntityListenerListener(){

            public void entityListenerAdded(EntityListenerEvent e) {
                if (AbstractCallbackListenersTab.this.isVisible() && AbstractCallbackListenersTab.this.getCreateEntityListenerAction() == e.getSource()) {
                    AbstractCallbackListenersTab.this.rebuildListenerClassCombo(e.getNewName());
                    AbstractCallbackListenersTab.this.rebuildTable();
                }
            }

            public void entityListenerChanged(EntityListenerEvent e) {
                if (AbstractCallbackListenersTab.this.isVisible() && e.getSource() == AbstractCallbackListenersTab.this) {
                    AbstractCallbackListenersTab.this.rebuildListenerClassCombo(e.getNewName());
                    AbstractCallbackListenersTab.this.rebuildTable();
                }
            }

            public void entityListenerRemoved(EntityListenerEvent e) {
                if (AbstractCallbackListenersTab.this.isVisible() && AbstractCallbackListenersTab.this.getRemoveEntityListenerAction() == e.getSource()) {
                    AbstractCallbackListenersTab.this.rebuildListenerClassCombo(null);
                    AbstractCallbackListenersTab.this.rebuildTable();
                }
            }
        });
    }

    protected void rebuildListenerClassCombo(String selectedListener) {
        List<EntityListener> entityListeners = this.getEntityListeners();
        ArrayList<String> listenerClasses = new ArrayList<String>();
        if (entityListeners != null) {
            for (EntityListener entityListener : this.getEntityListeners()) {
                listenerClasses.add(entityListener.getClassName());
            }
        }
        this.listenerClassCombo.setModel(new DefaultComboBoxModel<Object>(listenerClasses.toArray()));
        this.getCreateCallbackMethodAction().setEnabled(listenerClasses.size() > 0);
        if (selectedListener == null) {
            if (listenerClasses.size() > 0) {
                this.listenerClassCombo.setSelectedIndex(0);
            }
        } else {
            this.listenerClassCombo.setSelectedItem(selectedListener);
        }
        this.mediator.setCurrentListenerClass((String)this.listenerClassCombo.getSelectedItem());
        this.getRemoveEntityListenerAction().setEnabled(listenerClasses.size() > 0);
        this.listenerClassCombo.setEnabled(listenerClasses.size() > 0);
    }

    @Override
    protected void buildFilter(DefaultFormBuilder builder) {
        this.listenerClassCombo = Application.getWidgetFactory().createComboBox();
        this.listenerClassCombo.setEditable(true);
        builder.append((Component)new JLabel("Listener class:"), (Component)this.listenerClassCombo);
        builder.nextLine();
        super.buildFilter(builder);
    }
}

