/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.CayenneMapEntry;

class SelectQueryPrefetchRouterAction
implements PrefetchProcessor {
    SelectQuery query;
    QueryRouter router;
    EntityResolver resolver;
    ClassDescriptor classDescriptor;

    SelectQueryPrefetchRouterAction() {
    }

    void route(SelectQuery query, QueryRouter router, EntityResolver resolver) {
        if (!query.isFetchingDataRows() && query.getPrefetchTree() != null) {
            this.query = query;
            this.router = router;
            this.resolver = resolver;
            this.classDescriptor = query.getMetaData(resolver).getClassDescriptor();
            query.getPrefetchTree().traverse(this);
        }
    }

    public boolean startPhantomPrefetch(PrefetchTreeNode node) {
        return true;
    }

    public boolean startDisjointPrefetch(PrefetchTreeNode node) {
        if (node == this.query.getPrefetchTree()) {
            return true;
        }
        String prefetchPath = node.getPath();
        Iterator<CayenneMapEntry> it = this.classDescriptor.getEntity().resolvePathComponents(prefetchPath);
        ObjRelationship relationship = null;
        while (it.hasNext()) {
            relationship = (ObjRelationship)it.next();
        }
        if (relationship == null) {
            throw new CayenneRuntimeException("Invalid prefetch '%s' for entity '%s'", prefetchPath, this.classDescriptor.getEntity().getName());
        }
        Expression queryQualifier = this.query.getQualifier();
        Expression entityQualifier = this.classDescriptor.getEntityInheritanceTree().qualifierForEntityAndSubclasses();
        if (entityQualifier != null) {
            queryQualifier = queryQualifier != null ? queryQualifier.andExp(entityQualifier) : entityQualifier;
        }
        PrefetchSelectQuery prefetchQuery = new PrefetchSelectQuery(prefetchPath, relationship);
        prefetchQuery.setStatementFetchSize(this.query.getStatementFetchSize());
        prefetchQuery.setQualifier(this.classDescriptor.getEntity().translateToRelatedEntity(queryQualifier, prefetchPath));
        if (relationship.isSourceIndependentFromTargetChange()) {
            prefetchQuery.addResultPath("db:" + relationship.getReverseDbRelationshipPath());
        }
        prefetchQuery.setPrefetchTree(node);
        prefetchQuery.route(this.router, this.resolver, null);
        return true;
    }

    public boolean startDisjointByIdPrefetch(PrefetchTreeNode prefetchTreeNode) {
        return true;
    }

    public boolean startJointPrefetch(PrefetchTreeNode node) {
        return true;
    }

    public boolean startUnknownPrefetch(PrefetchTreeNode node) {
        if (node == this.query.getPrefetchTree()) {
            return true;
        }
        return this.startDisjointPrefetch(node);
    }

    public void finishPrefetch(PrefetchTreeNode node) {
    }
}

