/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.Validating;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.cayenne.xml.XMLDecoder;
import org.apache.cayenne.xml.XMLEncoder;
import org.apache.cayenne.xml.XMLSerializable;

public class CayenneDataObject
extends PersistentObject
implements DataObject,
Validating,
XMLSerializable {
    protected long snapshotVersion = Long.MIN_VALUE;
    protected Map<String, Object> values = new HashMap<String, Object>();

    public void setPersistenceState(int persistenceState) {
        this.persistenceState = persistenceState;
        if (persistenceState == 5) {
            this.values.clear();
        }
    }

    public Object readNestedProperty(String path) {
        Object property;
        if (null == path || 0 == path.length()) {
            throw new IllegalArgumentException("the path must be supplied in order to lookup a nested property");
        }
        int dotIndex = path.indexOf(46);
        if (0 == dotIndex) {
            throw new IllegalArgumentException("the path is invalid because it starts with a period character");
        }
        if (dotIndex == path.length() - 1) {
            throw new IllegalArgumentException("the path is invalid because it ends with a period character");
        }
        if (-1 == dotIndex) {
            return this.readSimpleProperty(path);
        }
        String path0 = path.substring(0, dotIndex);
        String pathRemainder = path.substring(dotIndex + 1);
        if ('+' == path0.charAt(path0.length() - 1)) {
            path0 = path0.substring(0, path0.length() - 1);
        }
        if ((property = this.readSimpleProperty(path0)) == null) {
            return null;
        }
        if (property instanceof DataObject) {
            return ((DataObject)property).readNestedProperty(pathRemainder);
        }
        return Cayenne.readNestedProperty(property, pathRemainder);
    }

    private final Object readSimpleProperty(String property) {
        Object object = this.readProperty(property);
        if (object == null && !this.values.containsKey(property)) {
            object = PropertyUtils.getProperty(this, property);
        }
        return object;
    }

    public Object readProperty(String propertyName) {
        Object object;
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, propertyName, false);
        }
        if ((object = this.readPropertyDirectly(propertyName)) instanceof Fault) {
            object = ((Fault)object).resolveFault(this, propertyName);
            this.writePropertyDirectly(propertyName, object);
        }
        return object;
    }

    public Object readPropertyDirectly(String propName) {
        return this.values.get(propName);
    }

    public void writeProperty(String propName, Object val) {
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, propName, false);
            Object oldValue = this.readPropertyDirectly(propName);
            this.objectContext.propertyChanged(this, propName, oldValue, val);
        }
        this.writePropertyDirectly(propName, val);
    }

    public void writePropertyDirectly(String propName, Object val) {
        this.values.put(propName, val);
    }

    public void removeToManyTarget(String relName, DataObject value, boolean setReverse) {
        Object holder = this.readProperty(relName);
        this.getObjectContext().propertyChanged(this, relName, value, null);
        if (holder instanceof Collection) {
            ((Collection)holder).remove(value);
        } else if (holder instanceof Map) {
            ((Map)holder).remove(this.getMapKey(relName, value));
        }
        if (value != null && setReverse) {
            this.unsetReverseRelationship(relName, value);
        }
    }

    public void addToManyTarget(String relName, DataObject value, boolean setReverse) {
        if (value == null) {
            throw new NullPointerException("Attempt to add null target DataObject.");
        }
        this.willConnect(relName, value);
        Object holder = this.readProperty(relName);
        this.getObjectContext().propertyChanged(this, relName, null, value);
        if (holder instanceof Collection) {
            ((Collection)holder).add(value);
        } else if (holder instanceof Map) {
            ((Map)holder).put(this.getMapKey(relName, value), value);
        }
        if (setReverse) {
            this.setReverseRelationship(relName, value);
        }
    }

    public void setToOneTarget(String relationshipName, DataObject value, boolean setReverse) {
        this.willConnect(relationshipName, value);
        Object oldTarget = this.readProperty(relationshipName);
        if (oldTarget == value) {
            return;
        }
        this.getObjectContext().propertyChanged(this, relationshipName, oldTarget, value);
        if (setReverse) {
            if (oldTarget instanceof DataObject) {
                this.unsetReverseRelationship(relationshipName, (DataObject)oldTarget);
            }
            if (value != null) {
                this.setReverseRelationship(relationshipName, value);
            }
        }
        this.objectContext.prepareForAccess(this, relationshipName, false);
        this.writePropertyDirectly(relationshipName, value);
    }

    protected void willConnect(String relationshipName, Persistent object) {
        if (object == null || this.getObjectContext() == object.getObjectContext()) {
            return;
        }
        if (this.getObjectContext() == null && object.getObjectContext() != null) {
            object.getObjectContext().registerNewObject(this);
        } else if (this.getObjectContext() != null && object.getObjectContext() == null) {
            this.getObjectContext().registerNewObject(object);
        } else {
            throw new CayenneRuntimeException("Cannot set object as destination of relationship " + relationshipName + " because it is in a different ObjectContext", new Object[0]);
        }
    }

    protected void setReverseRelationship(String relName, DataObject val) {
        ObjRelationship rel = (ObjRelationship)this.objectContext.getEntityResolver().getObjEntity(this.objectId.getEntityName()).getRelationship(relName);
        ObjRelationship revRel = rel.getReverseRelationship();
        if (revRel != null) {
            if (revRel.isToMany()) {
                val.addToManyTarget(revRel.getName(), this, false);
            } else {
                val.setToOneTarget(revRel.getName(), this, false);
            }
        }
    }

    protected void unsetReverseRelationship(String relName, DataObject val) {
        EntityResolver resolver = this.objectContext.getEntityResolver();
        ObjEntity entity = resolver.getObjEntity(this.objectId.getEntityName());
        if (entity == null) {
            throw new IllegalStateException("DataObject's entity is unmapped, objectId: " + this.objectId);
        }
        ObjRelationship rel = (ObjRelationship)entity.getRelationship(relName);
        ObjRelationship revRel = rel.getReverseRelationship();
        if (revRel != null) {
            if (revRel.isToMany()) {
                val.removeToManyTarget(revRel.getName(), this, false);
            } else {
                val.setToOneTarget(revRel.getName(), null, false);
            }
        }
    }

    public StringBuffer toStringBuffer(StringBuffer buffer, boolean fullDesc) {
        String id = this.objectId != null ? this.objectId.toString() : "<no id>";
        String state = PersistenceState.persistenceStateName(this.persistenceState);
        buffer.append('{').append(id).append("; ").append(state).append("; ");
        if (fullDesc) {
            this.appendProperties(buffer);
        }
        buffer.append("}");
        return buffer;
    }

    protected void appendProperties(StringBuffer buffer) {
        buffer.append("[");
        Iterator<Map.Entry<String, Object>> it = this.values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            buffer.append(entry.getKey()).append("=>");
            Object value = entry.getValue();
            if (value instanceof Persistent) {
                buffer.append('{').append(((Persistent)value).getObjectId()).append('}');
            } else if (value instanceof Collection) {
                buffer.append("(..)");
            } else if (value instanceof Fault) {
                buffer.append('?');
            } else {
                buffer.append(value);
            }
            if (!it.hasNext()) continue;
            buffer.append("; ");
        }
        buffer.append("]");
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer(), true).toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.persistenceState);
        switch (this.persistenceState) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                out.writeObject(this.values);
            }
        }
        out.writeObject(this.objectId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.persistenceState = in.readInt();
        switch (this.persistenceState) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.values = (Map)in.readObject();
                break;
            }
            case 3: 
            case 5: {
                this.persistenceState = 5;
                this.values = new HashMap<String, Object>();
            }
        }
        this.objectId = (ObjectId)in.readObject();
    }

    public long getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(long snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public static String makePath(String ... pathParts) {
        return Cayenne.makePath(pathParts);
    }

    protected void validateForSave(ValidationResult validationResult) {
        ObjEntity objEntity = this.getObjectContext().getEntityResolver().lookupObjEntity(this);
        if (objEntity == null) {
            throw new CayenneRuntimeException("No ObjEntity mapping found for DataObject " + this.getClass().getName(), new Object[0]);
        }
        HashMap<String, ValidationFailure> failedDbAttributes = null;
        for (ObjAttribute next : objEntity.getAttributes()) {
            int len;
            String message;
            ValidationFailure failure;
            if (next instanceof EmbeddedAttribute) continue;
            ObjAttribute objAttribute = next;
            DbAttribute dbAttribute = objAttribute.getDbAttribute();
            if (dbAttribute == null) {
                throw new CayenneRuntimeException("ObjAttribute '" + objAttribute.getName() + "' does not have a corresponding DbAttribute", new Object[0]);
            }
            if (dbAttribute.isPrimaryKey()) continue;
            Object value = this.readPropertyDirectly(objAttribute.getName());
            if (dbAttribute.isMandatory() && (failure = BeanValidationFailure.validateNotNull(this, objAttribute.getName(), value)) != null) {
                if (failedDbAttributes == null) {
                    failedDbAttributes = new HashMap<String, ValidationFailure>();
                }
                failedDbAttributes.put(dbAttribute.getName(), failure);
                continue;
            }
            if (value == null || dbAttribute.getMaxLength() <= 0) continue;
            if (value.getClass().isArray()) {
                int len2 = Array.getLength(value);
                if (len2 <= dbAttribute.getMaxLength()) continue;
                message = "\"" + objAttribute.getName() + "\" exceeds maximum allowed length (" + dbAttribute.getMaxLength() + " bytes): " + len2;
                validationResult.addFailure(new BeanValidationFailure(this, objAttribute.getName(), message));
                continue;
            }
            if (!(value instanceof CharSequence) || (len = ((CharSequence)value).length()) <= dbAttribute.getMaxLength()) continue;
            message = "\"" + objAttribute.getName() + "\" exceeds maximum allowed length (" + dbAttribute.getMaxLength() + " chars): " + len;
            validationResult.addFailure(new BeanValidationFailure(this, objAttribute.getName(), message));
        }
        for (ObjRelationship relationship : objEntity.getRelationships()) {
            List<DbRelationship> dbRels;
            if (relationship.isSourceIndependentFromTargetChange() || (dbRels = relationship.getDbRelationships()).isEmpty()) continue;
            boolean validate = true;
            DbRelationship dbRelationship = dbRels.get(0);
            for (DbJoin join : dbRelationship.getJoins()) {
                DbAttribute source = join.getSource();
                if (source.isMandatory()) {
                    if (failedDbAttributes == null || failedDbAttributes.isEmpty()) continue;
                    failedDbAttributes.remove(source.getName());
                    if (failedDbAttributes.isEmpty()) continue;
                    continue;
                }
                validate = false;
            }
            if (!validate) continue;
            Object value = this.readPropertyDirectly(relationship.getName());
            ValidationFailure failure = BeanValidationFailure.validateNotNull(this, relationship.getName(), value);
            if (failure == null) continue;
            validationResult.addFailure(failure);
        }
        if (failedDbAttributes != null && !failedDbAttributes.isEmpty()) {
            for (ValidationFailure failure : failedDbAttributes.values()) {
                validationResult.addFailure(failure);
            }
        }
    }

    public void validateForInsert(ValidationResult validationResult) {
        this.validateForSave(validationResult);
    }

    public void validateForUpdate(ValidationResult validationResult) {
        this.validateForSave(validationResult);
    }

    public void validateForDelete(ValidationResult validationResult) {
    }

    @Deprecated
    public void encodeAsXML(XMLEncoder encoder) {
        EntityResolver er = this.getObjectContext().getEntityResolver();
        ObjEntity objectEntity = er.lookupObjEntity(this.getClass());
        String[] fields = this.getClass().getName().split("\\.");
        encoder.setRoot(fields[fields.length - 1], this.getClass().getName());
        for (ObjAttribute att : objectEntity.getDeclaredAttributes()) {
            String name = att.getName();
            encoder.encodeProperty(name, this.readNestedProperty(name));
        }
    }

    @Deprecated
    public void decodeFromXML(XMLDecoder decoder) {
        Injector injector = CayenneRuntime.getThreadInjector();
        if (injector == null) {
            throw new IllegalStateException("Can't perform deserialization - no Injector bound to the current thread.");
        }
        EntityResolver resolver = injector.getInstance(DataChannel.class).getEntityResolver();
        ObjEntity objectEntity = resolver.lookupObjEntity(this.getClass());
        for (ObjAttribute att : objectEntity.getDeclaredAttributes()) {
            String name = att.getName();
            this.writeProperty(name, decoder.decodeObject(name));
        }
    }

    public void setObjectContext(ObjectContext objectContext) {
        this.objectContext = objectContext;
        if (objectContext == null) {
            this.persistenceState = 1;
        }
    }
}

