/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/

package org.apache.cayenne.testdo.qualified.auto;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.testdo.qualified.Qualified3;

/**
 * Class _Qualified2 was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Qualified4 extends CayenneDataObject {

    public static final String NAME_PROPERTY = "name";
    public static final String QUALIFIED3_PROPERTY = "qualified3";

    public static final String ID_PK_COLUMN = "ID";

    public void setName(String name) {
        writeProperty(NAME_PROPERTY, name);
    }
    public String getName() {
        return (String)readProperty(NAME_PROPERTY);
    }

    public void setQualified3(Qualified3 qualified3) {
        setToOneTarget(QUALIFIED3_PROPERTY, qualified3, true);
    }

    public Qualified3 getQualified3() {
        return (Qualified3)readProperty(QUALIFIED3_PROPERTY);
    }


}
