/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.impl.WildcardPermissionBasedAuthorizationImpl;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.sidecar.acl.authorization.Permission;
import org.apache.cassandra.sidecar.acl.authorization.StandardPermission;

public class CompositePermission
extends StandardPermission {
    private final WildcardPermissionBasedAuthorization nameAuthorization;
    private final List<Permission> permissions;

    public CompositePermission(String name, List<Permission> permissions) {
        super(name);
        if (permissions == null || permissions.isEmpty()) {
            throw new IllegalArgumentException("CompositePermission can not be created with null or empty permissions");
        }
        this.nameAuthorization = new WildcardPermissionBasedAuthorizationImpl(name);
        this.permissions = Collections.unmodifiableList(permissions);
    }

    public WildcardPermissionBasedAuthorization nameAuthorization() {
        return this.nameAuthorization;
    }

    public List<Permission> childPermissions() {
        return this.permissions;
    }

    @Override
    public Authorization toAuthorization(String resource) {
        AndAuthorization authorization = AndAuthorization.create();
        for (Permission permission : this.permissions) {
            authorization.addAuthorization(permission.toAuthorization(resource));
        }
        return authorization;
    }
}

