/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Vertx;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;
import java.util.Map;
import org.apache.cassandra.sidecar.acl.authentication.AuthenticationHandlerFactory;
import org.apache.cassandra.sidecar.acl.authentication.JwtParameterExtractor;
import org.apache.cassandra.sidecar.acl.authentication.JwtParameters;
import org.apache.cassandra.sidecar.acl.authentication.JwtRoleProcessor;
import org.apache.cassandra.sidecar.acl.authentication.ReloadingJwtAuthenticationHandler;
import org.apache.cassandra.sidecar.config.AccessControlConfiguration;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;

@Singleton
public class JwtAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    private final JwtRoleProcessor roleProcessor;
    private final PeriodicTaskExecutor periodicTaskExecutor;

    @Inject
    public JwtAuthenticationHandlerFactory(JwtRoleProcessor roleProcessor, PeriodicTaskExecutor periodicTaskExecutor) {
        this.roleProcessor = roleProcessor;
        this.periodicTaskExecutor = periodicTaskExecutor;
    }

    @Override
    public AuthenticationHandlerInternal create(Vertx vertx, AccessControlConfiguration accessControlConfiguration, Map<String, String> parameters) throws ConfigurationException {
        JwtParameters jwtParameters = this.parameterParser(parameters);
        return new ReloadingJwtAuthenticationHandler(vertx, jwtParameters, this.roleProcessor, this.periodicTaskExecutor);
    }

    protected JwtParameters parameterParser(Map<String, String> parameters) {
        return new JwtParameterExtractor(parameters);
    }
}

