/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.joda;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LocalDateCodec
extends TypeCodec<LocalDate> {
    public static final LocalDateCodec instance = new LocalDateCodec();
    private static final LocalDate EPOCH = new LocalDate(1970, 1, 1);
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();

    private LocalDateCodec() {
        super(DataType.date(), LocalDate.class);
    }

    public ByteBuffer serialize(LocalDate value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        Days days = Days.daysBetween((ReadablePartial)EPOCH, (ReadablePartial)value);
        int unsigned = CodecUtils.fromSignedToUnsignedInt((int)days.getDays());
        return LocalDateCodec.cint().serializeNoBoxing(unsigned, protocolVersion);
    }

    public LocalDate deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int unsigned = LocalDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion);
        int signed = CodecUtils.fromUnsignedToSignedInt((int)unsigned);
        return EPOCH.plusDays(signed);
    }

    public String format(LocalDate value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote((String)FORMATTER.print((ReadablePartial)value));
    }

    public LocalDate parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted((String)value)) {
            value = ParseUtils.unquote((String)value);
        }
        if (ParseUtils.isLongLiteral((String)value)) {
            int days;
            long raw;
            try {
                raw = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            try {
                days = CodecUtils.fromCqlDateToDaysSinceEpoch((long)raw);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            return EPOCH.plusDays(days);
        }
        try {
            return LocalDate.parse((String)value, (DateTimeFormatter)FORMATTER);
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
        }
    }
}

