/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.matching;

import org.psjava.algo.graph.flownetwork.MaximumFlowAlgorithm;
import org.psjava.algo.graph.flownetwork.MaximumFlowAlgorithmResult;
import org.psjava.algo.graph.matching.MaximumBipartiteMatchingAlgorithm;
import org.psjava.algo.graph.matching.MaximumBipartiteMatchingResult;
import org.psjava.ds.graph.AllEdgeInGraph;
import org.psjava.ds.graph.BipartiteGraph;
import org.psjava.ds.graph.BipartiteGraphEdge;
import org.psjava.ds.graph.CapacityEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.MutableCapacityGraph;
import org.psjava.ds.map.Map;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.math.Function;
import org.psjava.ds.numbersystrem.IntegerNumberSystem;
import org.psjava.goods.GoodMutableMapFactory;

public class MaximumBipartiteMatchingAlgorithmUsingMaximumFlow {
    private static final Object VIRTUAL_START = new Object();
    private static final Object VIRTUAl_END = new Object();

    public static MaximumBipartiteMatchingAlgorithm getInstance(final MaximumFlowAlgorithm maxFlow) {
        return new MaximumBipartiteMatchingAlgorithm(){

            @Override
            public <V> MaximumBipartiteMatchingResult<V> calc(BipartiteGraph<V> graph) {
                MutableCapacityGraph augmented = MaximumBipartiteMatchingAlgorithmUsingMaximumFlow.constructAugmentedCapacityGraph(graph);
                MaximumFlowAlgorithmResult maxFlowResult = maxFlow.calc(augmented, VIRTUAL_START, VIRTUAl_END, IntegerNumberSystem.getInstance());
                Map matchMap = MaximumBipartiteMatchingAlgorithmUsingMaximumFlow.createMatchMapFromMaxFlowResult(augmented, maxFlowResult);
                return MaximumBipartiteMatchingAlgorithmUsingMaximumFlow.wrapResult(matchMap);
            }
        };
    }

    private static <V> MutableCapacityGraph<Object, Integer> constructAugmentedCapacityGraph(BipartiteGraph<V> original) {
        MutableCapacityGraph<Object, Integer> augmented = MutableCapacityGraph.create();
        augmented.insertVertex(VIRTUAL_START);
        augmented.insertVertex(VIRTUAl_END);
        for (Object t : original.getLeftVertices()) {
            augmented.insertVertex(t);
            augmented.addEdge(VIRTUAL_START, t, 1);
        }
        for (Object t : original.getRightVertices()) {
            augmented.insertVertex(t);
            augmented.addEdge(t, VIRTUAl_END, 1);
        }
        for (BipartiteGraphEdge bipartiteGraphEdge : original.getEdges()) {
            augmented.addEdge(bipartiteGraphEdge.left(), bipartiteGraphEdge.right(), 1);
        }
        return augmented;
    }

    private static <V> Map<V, V> createMatchMapFromMaxFlowResult(Graph<Object, CapacityEdge<Object, Integer>> augmented, MaximumFlowAlgorithmResult<Integer, CapacityEdge<Object, Integer>> maxFlowResult) {
        Function<CapacityEdge<Object, Integer>, Integer> flowFunction = maxFlowResult.calcFlowFunction();
        MutableMap map = GoodMutableMapFactory.getInstance().create();
        for (CapacityEdge<Object, Integer> e : AllEdgeInGraph.wrap(augmented)) {
            if (flowFunction.get(e) != 1 || e.from() == VIRTUAL_START || e.to() == VIRTUAl_END) continue;
            map.add(e.from(), e.to());
            map.add(e.to(), e.from());
        }
        return map;
    }

    private static <V> MaximumBipartiteMatchingResult<V> wrapResult(final Map<V, V> matchMap) {
        return new MaximumBipartiteMatchingResult<V>(){

            @Override
            public V getMatchedVertex(V v) {
                return matchMap.get(v);
            }

            @Override
            public int getMaxMatchCount() {
                return matchMap.size() / 2;
            }

            @Override
            public boolean hasMatch(V from) {
                return matchMap.containsKey(from);
            }
        };
    }
}

