/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentOrdering;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableIndex
implements SegmentOrdering,
Comparable<SSTableIndex> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableIndex.class);
    public static final Comparator<SSTableIndex> COMPARATOR = Comparator.comparing(s -> s.getSSTable().getFirst()).thenComparing(s -> s.getSSTable().getLast()).thenComparing(s -> s.getSSTable().descriptor.id, SSTableIdFactory.COMPARATOR);
    protected final SSTableContext sstableContext;
    protected final IndexTermType indexTermType;
    protected final IndexIdentifier indexIdentifier;
    private final AtomicInteger references = new AtomicInteger(1);
    private final AtomicBoolean obsolete = new AtomicBoolean(false);

    public SSTableIndex(SSTableContext sstableContext, StorageAttachedIndex index) {
        this.sstableContext = sstableContext.sharedCopy();
        this.indexTermType = index.termType();
        this.indexIdentifier = index.identifier();
    }

    public abstract long indexFileCacheSize();

    public abstract long getRowCount();

    public abstract long minSSTableRowId();

    public abstract long maxSSTableRowId();

    public abstract ByteBuffer minTerm();

    public abstract ByteBuffer maxTerm();

    public abstract AbstractBounds<PartitionPosition> bounds();

    public abstract List<KeyRangeIterator> search(Expression var1, AbstractBounds<PartitionPosition> var2, QueryContext var3) throws IOException;

    public abstract void populateSegmentView(SimpleDataSet var1);

    protected abstract void internalRelease();

    public long sizeOfPerColumnComponents() {
        return this.sstableContext.indexDescriptor.sizeOnDiskOfPerIndexComponents(this.indexTermType, this.indexIdentifier);
    }

    public IndexTermType getIndexTermType() {
        return this.indexTermType;
    }

    public IndexIdentifier getIndexIdentifier() {
        return this.indexIdentifier;
    }

    public SSTableContext getSSTableContext() {
        return this.sstableContext;
    }

    public Version getVersion() {
        return this.sstableContext.indexDescriptor.version;
    }

    public SSTableReader getSSTable() {
        return this.sstableContext.sstable;
    }

    public boolean reference() {
        int n;
        do {
            if ((n = this.references.get()) > 0) continue;
            return false;
        } while (!this.references.compareAndSet(n, n + 1));
        return true;
    }

    public boolean isReleased() {
        return this.references.get() <= 0;
    }

    public void releaseQuietly() {
        try {
            this.release();
        }
        catch (Throwable e) {
            logger.error(this.indexIdentifier.logMessage("Failed to release index on SSTable {}"), (Object)this.getSSTable().descriptor, (Object)e);
        }
    }

    public void release() {
        int n = this.references.decrementAndGet();
        if (n == 0) {
            this.internalRelease();
            this.sstableContext.close();
            if (this.obsolete.get()) {
                this.sstableContext.indexDescriptor.deleteColumnIndex(this.indexTermType, this.indexIdentifier);
            }
        }
    }

    public void markObsolete() {
        this.obsolete.getAndSet(true);
        this.release();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSTableIndex other = (SSTableIndex)o;
        return Objects.equal((Object)this.sstableContext, (Object)other.sstableContext) && Objects.equal((Object)this.indexTermType, (Object)other.indexTermType) && Objects.equal((Object)this.indexIdentifier, (Object)other.indexIdentifier);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sstableContext, this.indexTermType, this.indexIdentifier});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.indexTermType.columnName()).add("sstable", (Object)this.sstableContext.sstable.descriptor).add("minTerm", (Object)this.indexTermType.asString(this.minTerm())).add("maxTerm", (Object)this.indexTermType.asString(this.maxTerm())).add("totalRows", this.sstableContext.sstable.getTotalRows()).toString();
    }

    @Override
    public int compareTo(SSTableIndex index) {
        return this.getSSTable().compareTo(index.getSSTable());
    }
}

