/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IPartitionerDependentSerializer;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public abstract class Token
implements RingPosition<Token>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final TokenSerializer serializer = new TokenSerializer();

    @Override
    public abstract IPartitioner getPartitioner();

    public abstract long getHeapSize();

    public abstract Object getTokenValue();

    public long getLongValue() {
        throw new UnsupportedOperationException();
    }

    public abstract ByteSource asComparableBytes(ByteComparable.Version var1);

    public abstract double size(Token var1);

    public abstract Token nextValidToken();

    @Override
    public Token getToken() {
        return this;
    }

    @Override
    public Token minValue() {
        return this.getPartitioner().getMinimumToken();
    }

    @Override
    public boolean isMinimum() {
        return this.equals(this.minValue());
    }

    public KeyBound minKeyBound() {
        return new KeyBound(this, true);
    }

    public KeyBound maxKeyBound() {
        if (this.isMinimum()) {
            return this.minKeyBound();
        }
        return new KeyBound(this, false);
    }

    public static class KeyBound
    implements PartitionPosition {
        private final Token token;
        public final boolean isMinimumBound;

        private KeyBound(Token t, boolean isMinimumBound) {
            this.token = t;
            this.isMinimumBound = isMinimumBound;
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public int compareTo(PartitionPosition pos) {
            if (this == pos) {
                return 0;
            }
            int cmp = this.getToken().compareTo(pos.getToken());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isMinimumBound) {
                return pos instanceof KeyBound && ((KeyBound)pos).isMinimumBound ? 0 : -1;
            }
            return pos instanceof KeyBound && !((KeyBound)pos).isMinimumBound ? 0 : 1;
        }

        @Override
        public ByteSource asComparableBytes(ByteComparable.Version version) {
            int terminator = this.isMinimumBound ? 32 : 96;
            return ByteSource.withTerminator(terminator, this.token.asComparableBytes(version));
        }

        @Override
        public ByteComparable asComparableBound(boolean before) {
            return this;
        }

        @Override
        public IPartitioner getPartitioner() {
            return this.getToken().getPartitioner();
        }

        @Override
        public KeyBound minValue() {
            return this.getPartitioner().getMinimumToken().minKeyBound();
        }

        @Override
        public boolean isMinimum() {
            return this.getToken().isMinimum();
        }

        @Override
        public PartitionPosition.Kind kind() {
            return this.isMinimumBound ? PartitionPosition.Kind.MIN_BOUND : PartitionPosition.Kind.MAX_BOUND;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            KeyBound other = (KeyBound)obj;
            return this.token.equals(other.token) && this.isMinimumBound == other.isMinimumBound;
        }

        public int hashCode() {
            return this.getToken().hashCode() + (this.isMinimumBound ? 0 : 1);
        }

        public String toString() {
            return String.format("%s(%s)", this.isMinimumBound ? "min" : "max", this.getToken().toString());
        }
    }

    public static class TokenSerializer
    implements IPartitionerDependentSerializer<Token> {
        @Override
        public void serialize(Token token, DataOutputPlus out, int version) throws IOException {
            IPartitioner p = token.getPartitioner();
            out.writeInt(p.getTokenFactory().byteSize(token));
            p.getTokenFactory().serialize(token, out);
        }

        @Override
        public Token deserialize(DataInput in, IPartitioner p, int version) throws IOException {
            int size = this.deserializeSize(in);
            byte[] bytes = new byte[size];
            in.readFully(bytes);
            return p.getTokenFactory().fromByteArray(ByteBuffer.wrap(bytes));
        }

        public int deserializeSize(DataInput in) throws IOException {
            return in.readInt();
        }

        @Override
        public long serializedSize(Token object, int version) {
            IPartitioner p = object.getPartitioner();
            int byteSize = p.getTokenFactory().byteSize(object);
            return TypeSizes.sizeof(byteSize) + byteSize;
        }
    }

    public static abstract class TokenFactory {
        public abstract ByteBuffer toByteArray(Token var1);

        public abstract Token fromByteArray(ByteBuffer var1);

        public ByteSource asComparableBytes(Token token, ByteComparable.Version version) {
            return token.asComparableBytes(version);
        }

        public abstract Token fromComparableBytes(ByteSource.Peekable var1, ByteComparable.Version var2);

        public abstract String toString(Token var1);

        public abstract Token fromString(String var1);

        public abstract void validate(String var1) throws ConfigurationException;

        public void serialize(Token token, DataOutputPlus out) throws IOException {
            out.write(this.toByteArray(token));
        }

        public void serialize(Token token, ByteBuffer out) throws IOException {
            out.put(this.toByteArray(token));
        }

        public Token fromByteBuffer(ByteBuffer bytes, int position, int length) {
            bytes = bytes.duplicate();
            bytes.position(position).limit(position + length);
            return this.fromByteArray(bytes);
        }

        public int byteSize(Token token) {
            return this.toByteArray(token).remaining();
        }
    }
}

