/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.net.Verb;

public class DroppedMessageMetrics {
    private static final String TYPE = "DroppedMessage";
    private static final ImmutableMap<Verb, String> REQUEST_VERB_ALIAS;
    public final Meter dropped;
    public final Timer internalDroppedLatency;
    public final Timer crossNodeDroppedLatency;

    public DroppedMessageMetrics(Verb verb) {
        String scope = verb.toString();
        if (REQUEST_VERB_ALIAS.containsKey((Object)verb)) {
            String alias = (String)REQUEST_VERB_ALIAS.get((Object)verb);
            this.dropped = CassandraMetricsRegistry.Metrics.meter(DefaultNameFactory.createMetricName(TYPE, "Dropped", scope), DefaultNameFactory.createMetricName(TYPE, "Dropped", alias));
            this.internalDroppedLatency = CassandraMetricsRegistry.Metrics.timer(DefaultNameFactory.createMetricName(TYPE, "InternalDroppedLatency", scope), DefaultNameFactory.createMetricName(TYPE, "InternalDroppedLatency", alias));
            this.crossNodeDroppedLatency = CassandraMetricsRegistry.Metrics.timer(DefaultNameFactory.createMetricName(TYPE, "CrossNodeDroppedLatency", scope), DefaultNameFactory.createMetricName(TYPE, "CrossNodeDroppedLatency", alias));
        } else {
            this.dropped = CassandraMetricsRegistry.Metrics.meter(DefaultNameFactory.createMetricName(TYPE, "Dropped", scope));
            this.internalDroppedLatency = CassandraMetricsRegistry.Metrics.timer(DefaultNameFactory.createMetricName(TYPE, "InternalDroppedLatency", scope));
            this.crossNodeDroppedLatency = CassandraMetricsRegistry.Metrics.timer(DefaultNameFactory.createMetricName(TYPE, "CrossNodeDroppedLatency", scope));
        }
    }

    static {
        EnumMap<Verb, String> aliases = new EnumMap<Verb, String>(Verb.class);
        aliases.put(Verb.BATCH_REMOVE_REQ, "BATCH_REMOVE");
        aliases.put(Verb.BATCH_STORE_REQ, "BATCH_STORE");
        aliases.put(Verb.COUNTER_MUTATION_REQ, "COUNTER_MUTATION");
        aliases.put(Verb.HINT_REQ, "HINT");
        aliases.put(Verb.MUTATION_REQ, "MUTATION");
        aliases.put(Verb.RANGE_REQ, "RANGE_SLICE");
        aliases.put(Verb.READ_REQ, "READ");
        aliases.put(Verb.READ_REPAIR_REQ, "READ_REPAIR");
        aliases.put(Verb.REQUEST_RSP, "REQUEST_RESPONSE");
        REQUEST_VERB_ALIAS = Maps.immutableEnumMap(aliases);
    }
}

