/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.transport.ConfiguredLimit;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeTransportService {
    private static final Logger logger = LoggerFactory.getLogger(NativeTransportService.class);
    private Collection<Server> servers = Collections.emptyList();
    private boolean initialized = false;
    private EventLoopGroup workerGroup;
    private ConfiguredLimit protocolVersionLimit;

    @VisibleForTesting
    synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        if (NativeTransportService.useEpoll()) {
            this.workerGroup = new EpollEventLoopGroup();
            logger.info("Netty using native Epoll event loop");
        } else {
            this.workerGroup = new NioEventLoopGroup();
            logger.info("Netty using Java NIO event loop");
        }
        this.protocolVersionLimit = ConfiguredLimit.newLimit();
        int nativePort = DatabaseDescriptor.getNativeTransportPort();
        int nativePortSSL = DatabaseDescriptor.getNativeTransportPortSSL();
        InetAddress nativeAddr = DatabaseDescriptor.getRpcAddress();
        Server.Builder builder = new Server.Builder().withEventLoopGroup(this.workerGroup).withProtocolVersionLimit(this.protocolVersionLimit).withHost(nativeAddr);
        this.servers = !DatabaseDescriptor.getClientEncryptionOptions().enabled ? Collections.singleton(builder.withSSL(false).withPort(nativePort).build()) : (nativePort != nativePortSSL ? Collections.unmodifiableList(Arrays.asList(builder.withSSL(false).withPort(nativePort).build(), builder.withSSL(true).withPort(nativePortSSL).build())) : Collections.singleton(builder.withSSL(true).withPort(nativePort).build()));
        ClientMetrics.instance.init(this.servers);
        this.initialized = true;
    }

    public void start() {
        this.initialize();
        this.servers.forEach(Server::start);
    }

    public void stop() {
        this.servers.forEach(Server::stop);
    }

    public void destroy() {
        this.stop();
        this.servers = Collections.emptyList();
        this.workerGroup.shutdownGracefully(3L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
        Message.Dispatcher.shutdown();
    }

    public int getMaxProtocolVersion() {
        return this.protocolVersionLimit.getMaxVersion();
    }

    public void refreshMaxNegotiableProtocolVersion() {
        if (this.initialized) {
            this.protocolVersionLimit.updateMaxSupportedVersion();
        }
    }

    public static boolean useEpoll() {
        boolean enableEpoll = Boolean.valueOf(System.getProperty("cassandra.native.epoll.enabled", "true"));
        return enableEpoll && Epoll.isAvailable();
    }

    public boolean isRunning() {
        for (Server server : this.servers) {
            if (!server.isRunning()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @VisibleForTesting
    Collection<Server> getServers() {
        return this.servers;
    }
}

