/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.messages.StreamInitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingStreamingConnection
extends Thread
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(IncomingStreamingConnection.class);
    private final int version;
    public final Socket socket;
    private final Set<Closeable> group;

    public IncomingStreamingConnection(int version, Socket socket, Set<Closeable> group) {
        super("STREAM-INIT-" + socket.getRemoteSocketAddress());
        this.version = version;
        this.socket = socket;
        this.group = group;
    }

    @Override
    public void run() {
        try {
            if (this.version != 4) {
                throw new IOException(String.format("Received stream using protocol version %d (my version %d). Terminating connection", this.version, 4));
            }
            DataInputPlus.DataInputStreamPlus input = new DataInputPlus.DataInputStreamPlus(this.socket.getInputStream());
            StreamInitMessage init = StreamInitMessage.serializer.deserialize(input, this.version);
            if (this.isEncryptionRequired(init.from) && !this.isEncrypted()) {
                logger.warn("Peer {} attempted to establish an unencrypted streaming connection (broadcast address {})", (Object)this.socket.getRemoteSocketAddress(), (Object)init.from);
                throw new IOException("Peer " + init.from + " attempted an unencrypted streaming connection");
            }
            if (!init.isForOutgoing) {
                this.socket.setSoTimeout(DatabaseDescriptor.getStreamingSocketTimeout());
            }
            StreamResultFuture.initReceivingSide(init.sessionIndex, init.planId, init.description, init.from, this, init.isForOutgoing, this.version, init.keepSSTableLevel, init.isIncremental);
        }
        catch (Throwable t) {
            logger.error("Error while reading from socket from {}.", (Object)this.socket.getRemoteSocketAddress(), (Object)t);
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            logger.debug("Error closing socket", (Throwable)e);
        }
        finally {
            this.group.remove(this);
        }
    }

    private boolean isEncryptionRequired(InetAddress peer) {
        return DatabaseDescriptor.getServerEncryptionOptions().shouldEncrypt(peer);
    }

    private boolean isEncrypted() {
        return this.socket instanceof SSLSocket;
    }
}

