/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class AbstractMarker
extends Term.NonTerminal {
    protected final int bindIndex;
    protected final ColumnSpecification receiver;

    protected AbstractMarker(int bindIndex, ColumnSpecification receiver) {
        this.bindIndex = bindIndex;
        this.receiver = receiver;
    }

    @Override
    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        boundNames.add(this.bindIndex, this.receiver);
    }

    @Override
    public boolean containsBindMarker() {
        return true;
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
    }

    public static class INRaw
    extends Raw {
        public INRaw(int bindIndex) {
            super(bindIndex);
        }

        private static ColumnSpecification makeInReceiver(ColumnSpecification receiver) {
            ColumnIdentifier inName = new ColumnIdentifier("in(" + receiver.name + ")", true);
            return new ColumnSpecification(receiver.ksName, receiver.cfName, inName, ListType.getInstance(receiver.type, false));
        }

        @Override
        public AbstractMarker prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            return new Lists.Marker(this.bindIndex(), INRaw.makeInReceiver(receiver));
        }
    }

    public static abstract class MultiColumnRaw
    extends Term.MultiColumnRaw {
        protected final int bindIndex;

        public MultiColumnRaw(int bindIndex) {
            this.bindIndex = bindIndex;
        }

        @Override
        public Term.NonTerminal prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            throw new AssertionError((Object)"MultiColumnRaw..prepare() requires a list of receivers");
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }

        @Override
        public String getText() {
            return "?";
        }
    }

    public static class Raw
    extends Term.Raw {
        private final int bindIndex;

        public Raw(int bindIndex) {
            this.bindIndex = bindIndex;
        }

        @Override
        public Term.NonTerminal prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                return new Constants.Marker(this.bindIndex, receiver);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Marker(this.bindIndex, receiver);
                }
                case SET: {
                    return new Sets.Marker(this.bindIndex, receiver);
                }
                case MAP: {
                    return new Maps.Marker(this.bindIndex, receiver);
                }
            }
            throw new AssertionError();
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }

        @Override
        public String getText() {
            return "?";
        }

        public int bindIndex() {
            return this.bindIndex;
        }
    }
}

