/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.ConnectionAPI;
import org.apache.cassandra.stress.settings.ConnectionStyle;
import org.apache.cassandra.stress.settings.CqlVersion;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;

public class SettingsMode
implements Serializable {
    public final ConnectionAPI api;
    public final ConnectionStyle style;
    public final CqlVersion cqlVersion;
    public final ProtocolVersion protocolVersion;
    public final String username;
    public final String password;
    public final String authProviderClassname;
    public final AuthProvider authProvider;
    public final Integer maxPendingPerConnection;
    public final Integer connectionsPerHost;
    private final String compression;

    public SettingsMode(GroupedOptions options) {
        if (options instanceof Cql3Options) {
            this.cqlVersion = CqlVersion.CQL3;
            Cql3Options opts = (Cql3Options)options;
            this.protocolVersion = "NEWEST_SUPPORTED".equals(opts.protocolVersion.value()) ? ProtocolVersion.NEWEST_SUPPORTED : ProtocolVersion.fromInt((int)Integer.parseInt(opts.protocolVersion.value()));
            this.api = opts.mode().displayPrefix.equals("native") ? ConnectionAPI.JAVA_DRIVER_NATIVE : ConnectionAPI.THRIFT;
            this.style = opts.useUnPrepared.setByUser() ? ConnectionStyle.CQL : ConnectionStyle.CQL_PREPARED;
            this.compression = ProtocolOptions.Compression.valueOf((String)opts.useCompression.value().toUpperCase()).name();
            this.username = opts.user.value();
            this.password = opts.password.value();
            this.maxPendingPerConnection = opts.maxPendingPerConnection.value().isEmpty() ? null : Integer.valueOf(opts.maxPendingPerConnection.value());
            this.connectionsPerHost = opts.connectionsPerHost.value().isEmpty() ? null : Integer.valueOf(opts.connectionsPerHost.value());
            this.authProviderClassname = opts.authProvider.value();
            if (this.authProviderClassname != null) {
                try {
                    Class<?> clazz = Class.forName(this.authProviderClassname);
                    if (!AuthProvider.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException(clazz + " is not a valid auth provider");
                    }
                    if (PlainTextAuthProvider.class.equals(clazz)) {
                        this.authProvider = (AuthProvider)clazz.getConstructor(String.class, String.class).newInstance(this.username, this.password);
                    }
                    this.authProvider = (AuthProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid auth provider class: " + opts.authProvider.value(), e);
                }
            } else {
                this.authProvider = null;
            }
        } else if (options instanceof Cql3SimpleNativeOptions) {
            this.cqlVersion = CqlVersion.CQL3;
            Cql3SimpleNativeOptions opts = (Cql3SimpleNativeOptions)options;
            this.protocolVersion = ProtocolVersion.NEWEST_SUPPORTED;
            this.api = ConnectionAPI.SIMPLE_NATIVE;
            this.style = opts.usePrepared.setByUser() ? ConnectionStyle.CQL_PREPARED : ConnectionStyle.CQL;
            this.compression = ProtocolOptions.Compression.NONE.name();
            this.username = null;
            this.password = null;
            this.authProvider = null;
            this.authProviderClassname = null;
            this.maxPendingPerConnection = null;
            this.connectionsPerHost = null;
        } else if (options instanceof ThriftOptions) {
            ThriftOptions opts = (ThriftOptions)options;
            this.protocolVersion = ProtocolVersion.NEWEST_SUPPORTED;
            this.cqlVersion = CqlVersion.NOCQL;
            this.api = opts.smart.setByUser() ? ConnectionAPI.THRIFT_SMART : ConnectionAPI.THRIFT;
            this.style = ConnectionStyle.THRIFT;
            this.compression = ProtocolOptions.Compression.NONE.name();
            this.username = opts.user.value();
            this.password = opts.password.value();
            this.authProviderClassname = null;
            this.authProvider = null;
            this.maxPendingPerConnection = null;
            this.connectionsPerHost = null;
        } else {
            throw new IllegalStateException();
        }
    }

    public ProtocolOptions.Compression compression() {
        return ProtocolOptions.Compression.valueOf((String)this.compression);
    }

    public static SettingsMode get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-mode");
        if (params == null) {
            Cql3NativeOptions opts = new Cql3NativeOptions();
            opts.accept("cql3");
            opts.accept("native");
            opts.accept("prepared");
            return new SettingsMode(opts);
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new GroupedOptions[]{new ThriftOptions(), new Cql3NativeOptions(), new Cql3SimpleNativeOptions()});
        if (options == null) {
            SettingsMode.printHelp();
            System.out.println("Invalid -mode options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsMode(options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-mode", new ThriftOptions(), new Cql3NativeOptions(), new Cql3SimpleNativeOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsMode.printHelp();
            }
        };
    }

    private static final class ThriftOptions
    extends GroupedOptions {
        final OptionSimple api = new OptionSimple("thrift", "", null, "", true);
        final OptionSimple smart = new OptionSimple("smart", "", null, "", false);
        final OptionSimple user = new OptionSimple("user=", ".+", null, "username", false);
        final OptionSimple password = new OptionSimple("password=", ".+", null, "password", false);

        private ThriftOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.api, this.smart, this.user, this.password);
        }
    }

    private static final class Cql3SimpleNativeOptions
    extends GroupedOptions {
        final OptionSimple api = new OptionSimple("cql3", "", null, "", true);
        final OptionSimple useSimpleNative = new OptionSimple("simplenative", "", null, "", true);
        final OptionSimple usePrepared = new OptionSimple("prepared", "", null, "", false);
        final OptionSimple port = new OptionSimple("port=", "[0-9]+", "9046", "", false);

        private Cql3SimpleNativeOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.useSimpleNative, this.usePrepared, this.api, this.port);
        }
    }

    private static abstract class Cql3Options
    extends GroupedOptions {
        final OptionSimple api = new OptionSimple("cql3", "", null, "", true);
        final OptionSimple protocolVersion = new OptionSimple("protocolVersion=", "[2-4]+", "NEWEST_SUPPORTED", "CQL Protocol Version", false);
        final OptionSimple useUnPrepared = new OptionSimple("unprepared", "", null, "force use of unprepared statements", false);
        final OptionSimple useCompression = new OptionSimple("compression=", "none|lz4|snappy", "none", "", false);
        final OptionSimple port = new OptionSimple("port=", "[0-9]+", "9046", "", false);
        final OptionSimple user = new OptionSimple("user=", ".+", null, "username", false);
        final OptionSimple password = new OptionSimple("password=", ".+", null, "password", false);
        final OptionSimple authProvider = new OptionSimple("auth-provider=", ".*", null, "Fully qualified implementation of com.datastax.driver.core.AuthProvider", false);
        final OptionSimple maxPendingPerConnection = new OptionSimple("maxPending=", "[0-9]+", "", "Maximum pending requests per connection", false);
        final OptionSimple connectionsPerHost = new OptionSimple("connectionsPerHost=", "[0-9]+", "", "Number of connections per host", false);

        private Cql3Options() {
        }

        abstract OptionSimple mode();

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.mode(), this.useUnPrepared, this.api, this.useCompression, this.port, this.user, this.password, this.authProvider, this.maxPendingPerConnection, this.connectionsPerHost, this.protocolVersion);
        }
    }

    private static final class Cql3ThriftOptions
    extends Cql3Options {
        final OptionSimple mode = new OptionSimple("thrift", "", null, "", true);

        private Cql3ThriftOptions() {
        }

        @Override
        OptionSimple mode() {
            return this.mode;
        }
    }

    private static final class Cql3NativeOptions
    extends Cql3Options {
        final OptionSimple mode = new OptionSimple("native", "", null, "", true);

        private Cql3NativeOptions() {
        }

        @Override
        OptionSimple mode() {
            return this.mode;
        }
    }
}

