/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.carbondata.core.metadata.datatype;

import java.io.IOException;

import org.apache.carbondata.core.util.DataTypeUtil;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

/**
 * This class is added to support backward compatibility with table info object, where DATATYPE
 * is string in old version(1.2) and OBJECT in new version(1.3)
 */
public class DataTypeAdapter extends TypeAdapter<Object> {

  private Gson fallBack_original = new Gson();

  @Override
  public void write(JsonWriter jsonWriter, Object o) {
  }

  @Override
  public Object read(JsonReader jsonReader) throws IOException {
    JsonToken token = jsonReader.peek();
    if (token == JsonToken.STRING) {
      return DataTypeUtil.valueOf(jsonReader.nextString());
    } else {
      // use original deserializer logic
      return fallBack_original.fromJson(jsonReader, DataType.class);
    }
  }

}
