/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
)

// IntegrationPlatformStatusApplyConfiguration represents an declarative configuration of the IntegrationPlatformStatus type for use
// with apply.
type IntegrationPlatformStatusApplyConfiguration struct {
	IntegrationPlatformSpecApplyConfiguration `json:",inline"`
	ObservedGeneration                        *int64                                           `json:"observedGeneration,omitempty"`
	Phase                                     *camelv1.IntegrationPlatformPhase                `json:"phase,omitempty"`
	Conditions                                []IntegrationPlatformConditionApplyConfiguration `json:"conditions,omitempty"`
	Version                                   *string                                          `json:"version,omitempty"`
	Info                                      map[string]string                                `json:"info,omitempty"`
}

// IntegrationPlatformStatusApplyConfiguration constructs an declarative configuration of the IntegrationPlatformStatus type for use with
// apply.
func IntegrationPlatformStatus() *IntegrationPlatformStatusApplyConfiguration {
	return &IntegrationPlatformStatusApplyConfiguration{}
}

// WithCluster sets the Cluster field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Cluster field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithCluster(value camelv1.IntegrationPlatformCluster) *IntegrationPlatformStatusApplyConfiguration {
	b.Cluster = &value
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithProfile(value camelv1.TraitProfile) *IntegrationPlatformStatusApplyConfiguration {
	b.Profile = &value
	return b
}

// WithBuild sets the Build field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Build field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithBuild(value *IntegrationPlatformBuildSpecApplyConfiguration) *IntegrationPlatformStatusApplyConfiguration {
	b.Build = value
	return b
}

// WithTraits sets the Traits field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Traits field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithTraits(value *TraitsApplyConfiguration) *IntegrationPlatformStatusApplyConfiguration {
	b.Traits = value
	return b
}

// WithConfiguration adds the given value to the Configuration field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Configuration field.
func (b *IntegrationPlatformStatusApplyConfiguration) WithConfiguration(values ...*ConfigurationSpecApplyConfiguration) *IntegrationPlatformStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConfiguration")
		}
		b.Configuration = append(b.Configuration, *values[i])
	}
	return b
}

// WithKamelet sets the Kamelet field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kamelet field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithKamelet(value *IntegrationPlatformKameletSpecApplyConfiguration) *IntegrationPlatformStatusApplyConfiguration {
	b.Kamelet = value
	return b
}

// WithObservedGeneration sets the ObservedGeneration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ObservedGeneration field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithObservedGeneration(value int64) *IntegrationPlatformStatusApplyConfiguration {
	b.ObservedGeneration = &value
	return b
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithPhase(value camelv1.IntegrationPlatformPhase) *IntegrationPlatformStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *IntegrationPlatformStatusApplyConfiguration) WithConditions(values ...*IntegrationPlatformConditionApplyConfiguration) *IntegrationPlatformStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *IntegrationPlatformStatusApplyConfiguration) WithVersion(value string) *IntegrationPlatformStatusApplyConfiguration {
	b.Version = &value
	return b
}

// WithInfo puts the entries into the Info field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Info field,
// overwriting an existing map entries in Info field with the same key.
func (b *IntegrationPlatformStatusApplyConfiguration) WithInfo(entries map[string]string) *IntegrationPlatformStatusApplyConfiguration {
	if b.Info == nil && len(entries) > 0 {
		b.Info = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Info[k] = v
	}
	return b
}
