/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformstatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationplatformstatus.traits.Knative;
import org.apache.camel.v1.integrationplatformstatus.traits.knative.Configuration;
import org.apache.camel.v1.integrationplatformstatus.traits.knative.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformstatus.traits.knative.ConfigurationFluent;

public class KnativeFluent<A extends KnativeFluent<A>>
extends BaseFluent<A> {
    private Boolean auto;
    private List<String> channelSinks;
    private List<String> channelSources;
    private String config;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private List<String> endpointSinks;
    private List<String> endpointSources;
    private List<String> eventSinks;
    private List<String> eventSources;
    private Boolean filterEventType;
    private Boolean filterSourceChannels;
    private List<String> filters;
    private Boolean namespaceLabel;
    private Boolean sinkBinding;

    public KnativeFluent() {
    }

    public KnativeFluent(Knative instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Knative instance) {
        Knative knative = instance = instance != null ? instance : new Knative();
        if (instance != null) {
            this.withAuto(instance.getAuto());
            this.withChannelSinks(instance.getChannelSinks());
            this.withChannelSources(instance.getChannelSources());
            this.withConfig(instance.getConfig());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withEndpointSinks(instance.getEndpointSinks());
            this.withEndpointSources(instance.getEndpointSources());
            this.withEventSinks(instance.getEventSinks());
            this.withEventSources(instance.getEventSources());
            this.withFilterEventType(instance.getFilterEventType());
            this.withFilterSourceChannels(instance.getFilterSourceChannels());
            this.withFilters(instance.getFilters());
            this.withNamespaceLabel(instance.getNamespaceLabel());
            this.withSinkBinding(instance.getSinkBinding());
        }
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public A addToChannelSinks(int index, String item) {
        if (this.channelSinks == null) {
            this.channelSinks = new ArrayList<String>();
        }
        this.channelSinks.add(index, item);
        return (A)((Object)this);
    }

    public A setToChannelSinks(int index, String item) {
        if (this.channelSinks == null) {
            this.channelSinks = new ArrayList<String>();
        }
        this.channelSinks.set(index, item);
        return (A)((Object)this);
    }

    public A addToChannelSinks(String ... items) {
        if (this.channelSinks == null) {
            this.channelSinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.channelSinks.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToChannelSinks(Collection<String> items) {
        if (this.channelSinks == null) {
            this.channelSinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.channelSinks.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromChannelSinks(String ... items) {
        if (this.channelSinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.channelSinks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromChannelSinks(Collection<String> items) {
        if (this.channelSinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.channelSinks.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getChannelSinks() {
        return this.channelSinks;
    }

    public String getChannelSink(int index) {
        return this.channelSinks.get(index);
    }

    public String getFirstChannelSink() {
        return this.channelSinks.get(0);
    }

    public String getLastChannelSink() {
        return this.channelSinks.get(this.channelSinks.size() - 1);
    }

    public String getMatchingChannelSink(Predicate<String> predicate) {
        for (String item : this.channelSinks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingChannelSink(Predicate<String> predicate) {
        for (String item : this.channelSinks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withChannelSinks(List<String> channelSinks) {
        if (channelSinks != null) {
            this.channelSinks = new ArrayList<String>();
            for (String item : channelSinks) {
                this.addToChannelSinks(item);
            }
        } else {
            this.channelSinks = null;
        }
        return (A)((Object)this);
    }

    public A withChannelSinks(String ... channelSinks) {
        if (this.channelSinks != null) {
            this.channelSinks.clear();
            this._visitables.remove((Object)"channelSinks");
        }
        if (channelSinks != null) {
            for (String item : channelSinks) {
                this.addToChannelSinks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasChannelSinks() {
        return this.channelSinks != null && !this.channelSinks.isEmpty();
    }

    public A addToChannelSources(int index, String item) {
        if (this.channelSources == null) {
            this.channelSources = new ArrayList<String>();
        }
        this.channelSources.add(index, item);
        return (A)((Object)this);
    }

    public A setToChannelSources(int index, String item) {
        if (this.channelSources == null) {
            this.channelSources = new ArrayList<String>();
        }
        this.channelSources.set(index, item);
        return (A)((Object)this);
    }

    public A addToChannelSources(String ... items) {
        if (this.channelSources == null) {
            this.channelSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.channelSources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToChannelSources(Collection<String> items) {
        if (this.channelSources == null) {
            this.channelSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.channelSources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromChannelSources(String ... items) {
        if (this.channelSources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.channelSources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromChannelSources(Collection<String> items) {
        if (this.channelSources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.channelSources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getChannelSources() {
        return this.channelSources;
    }

    public String getChannelSource(int index) {
        return this.channelSources.get(index);
    }

    public String getFirstChannelSource() {
        return this.channelSources.get(0);
    }

    public String getLastChannelSource() {
        return this.channelSources.get(this.channelSources.size() - 1);
    }

    public String getMatchingChannelSource(Predicate<String> predicate) {
        for (String item : this.channelSources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingChannelSource(Predicate<String> predicate) {
        for (String item : this.channelSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withChannelSources(List<String> channelSources) {
        if (channelSources != null) {
            this.channelSources = new ArrayList<String>();
            for (String item : channelSources) {
                this.addToChannelSources(item);
            }
        } else {
            this.channelSources = null;
        }
        return (A)((Object)this);
    }

    public A withChannelSources(String ... channelSources) {
        if (this.channelSources != null) {
            this.channelSources.clear();
            this._visitables.remove((Object)"channelSources");
        }
        if (channelSources != null) {
            for (String item : channelSources) {
                this.addToChannelSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasChannelSources() {
        return this.channelSources != null && !this.channelSources.isEmpty();
    }

    public String getConfig() {
        return this.config;
    }

    public A withConfig(String config) {
        this.config = config;
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToEndpointSinks(int index, String item) {
        if (this.endpointSinks == null) {
            this.endpointSinks = new ArrayList<String>();
        }
        this.endpointSinks.add(index, item);
        return (A)((Object)this);
    }

    public A setToEndpointSinks(int index, String item) {
        if (this.endpointSinks == null) {
            this.endpointSinks = new ArrayList<String>();
        }
        this.endpointSinks.set(index, item);
        return (A)((Object)this);
    }

    public A addToEndpointSinks(String ... items) {
        if (this.endpointSinks == null) {
            this.endpointSinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.endpointSinks.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEndpointSinks(Collection<String> items) {
        if (this.endpointSinks == null) {
            this.endpointSinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.endpointSinks.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEndpointSinks(String ... items) {
        if (this.endpointSinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.endpointSinks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndpointSinks(Collection<String> items) {
        if (this.endpointSinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.endpointSinks.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEndpointSinks() {
        return this.endpointSinks;
    }

    public String getEndpointSink(int index) {
        return this.endpointSinks.get(index);
    }

    public String getFirstEndpointSink() {
        return this.endpointSinks.get(0);
    }

    public String getLastEndpointSink() {
        return this.endpointSinks.get(this.endpointSinks.size() - 1);
    }

    public String getMatchingEndpointSink(Predicate<String> predicate) {
        for (String item : this.endpointSinks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEndpointSink(Predicate<String> predicate) {
        for (String item : this.endpointSinks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpointSinks(List<String> endpointSinks) {
        if (endpointSinks != null) {
            this.endpointSinks = new ArrayList<String>();
            for (String item : endpointSinks) {
                this.addToEndpointSinks(item);
            }
        } else {
            this.endpointSinks = null;
        }
        return (A)((Object)this);
    }

    public A withEndpointSinks(String ... endpointSinks) {
        if (this.endpointSinks != null) {
            this.endpointSinks.clear();
            this._visitables.remove((Object)"endpointSinks");
        }
        if (endpointSinks != null) {
            for (String item : endpointSinks) {
                this.addToEndpointSinks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndpointSinks() {
        return this.endpointSinks != null && !this.endpointSinks.isEmpty();
    }

    public A addToEndpointSources(int index, String item) {
        if (this.endpointSources == null) {
            this.endpointSources = new ArrayList<String>();
        }
        this.endpointSources.add(index, item);
        return (A)((Object)this);
    }

    public A setToEndpointSources(int index, String item) {
        if (this.endpointSources == null) {
            this.endpointSources = new ArrayList<String>();
        }
        this.endpointSources.set(index, item);
        return (A)((Object)this);
    }

    public A addToEndpointSources(String ... items) {
        if (this.endpointSources == null) {
            this.endpointSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.endpointSources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEndpointSources(Collection<String> items) {
        if (this.endpointSources == null) {
            this.endpointSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.endpointSources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEndpointSources(String ... items) {
        if (this.endpointSources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.endpointSources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndpointSources(Collection<String> items) {
        if (this.endpointSources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.endpointSources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEndpointSources() {
        return this.endpointSources;
    }

    public String getEndpointSource(int index) {
        return this.endpointSources.get(index);
    }

    public String getFirstEndpointSource() {
        return this.endpointSources.get(0);
    }

    public String getLastEndpointSource() {
        return this.endpointSources.get(this.endpointSources.size() - 1);
    }

    public String getMatchingEndpointSource(Predicate<String> predicate) {
        for (String item : this.endpointSources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEndpointSource(Predicate<String> predicate) {
        for (String item : this.endpointSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpointSources(List<String> endpointSources) {
        if (endpointSources != null) {
            this.endpointSources = new ArrayList<String>();
            for (String item : endpointSources) {
                this.addToEndpointSources(item);
            }
        } else {
            this.endpointSources = null;
        }
        return (A)((Object)this);
    }

    public A withEndpointSources(String ... endpointSources) {
        if (this.endpointSources != null) {
            this.endpointSources.clear();
            this._visitables.remove((Object)"endpointSources");
        }
        if (endpointSources != null) {
            for (String item : endpointSources) {
                this.addToEndpointSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndpointSources() {
        return this.endpointSources != null && !this.endpointSources.isEmpty();
    }

    public A addToEventSinks(int index, String item) {
        if (this.eventSinks == null) {
            this.eventSinks = new ArrayList<String>();
        }
        this.eventSinks.add(index, item);
        return (A)((Object)this);
    }

    public A setToEventSinks(int index, String item) {
        if (this.eventSinks == null) {
            this.eventSinks = new ArrayList<String>();
        }
        this.eventSinks.set(index, item);
        return (A)((Object)this);
    }

    public A addToEventSinks(String ... items) {
        if (this.eventSinks == null) {
            this.eventSinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.eventSinks.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEventSinks(Collection<String> items) {
        if (this.eventSinks == null) {
            this.eventSinks = new ArrayList<String>();
        }
        for (String item : items) {
            this.eventSinks.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEventSinks(String ... items) {
        if (this.eventSinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.eventSinks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEventSinks(Collection<String> items) {
        if (this.eventSinks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.eventSinks.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEventSinks() {
        return this.eventSinks;
    }

    public String getEventSink(int index) {
        return this.eventSinks.get(index);
    }

    public String getFirstEventSink() {
        return this.eventSinks.get(0);
    }

    public String getLastEventSink() {
        return this.eventSinks.get(this.eventSinks.size() - 1);
    }

    public String getMatchingEventSink(Predicate<String> predicate) {
        for (String item : this.eventSinks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEventSink(Predicate<String> predicate) {
        for (String item : this.eventSinks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEventSinks(List<String> eventSinks) {
        if (eventSinks != null) {
            this.eventSinks = new ArrayList<String>();
            for (String item : eventSinks) {
                this.addToEventSinks(item);
            }
        } else {
            this.eventSinks = null;
        }
        return (A)((Object)this);
    }

    public A withEventSinks(String ... eventSinks) {
        if (this.eventSinks != null) {
            this.eventSinks.clear();
            this._visitables.remove((Object)"eventSinks");
        }
        if (eventSinks != null) {
            for (String item : eventSinks) {
                this.addToEventSinks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEventSinks() {
        return this.eventSinks != null && !this.eventSinks.isEmpty();
    }

    public A addToEventSources(int index, String item) {
        if (this.eventSources == null) {
            this.eventSources = new ArrayList<String>();
        }
        this.eventSources.add(index, item);
        return (A)((Object)this);
    }

    public A setToEventSources(int index, String item) {
        if (this.eventSources == null) {
            this.eventSources = new ArrayList<String>();
        }
        this.eventSources.set(index, item);
        return (A)((Object)this);
    }

    public A addToEventSources(String ... items) {
        if (this.eventSources == null) {
            this.eventSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.eventSources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEventSources(Collection<String> items) {
        if (this.eventSources == null) {
            this.eventSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.eventSources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEventSources(String ... items) {
        if (this.eventSources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.eventSources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEventSources(Collection<String> items) {
        if (this.eventSources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.eventSources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEventSources() {
        return this.eventSources;
    }

    public String getEventSource(int index) {
        return this.eventSources.get(index);
    }

    public String getFirstEventSource() {
        return this.eventSources.get(0);
    }

    public String getLastEventSource() {
        return this.eventSources.get(this.eventSources.size() - 1);
    }

    public String getMatchingEventSource(Predicate<String> predicate) {
        for (String item : this.eventSources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEventSource(Predicate<String> predicate) {
        for (String item : this.eventSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEventSources(List<String> eventSources) {
        if (eventSources != null) {
            this.eventSources = new ArrayList<String>();
            for (String item : eventSources) {
                this.addToEventSources(item);
            }
        } else {
            this.eventSources = null;
        }
        return (A)((Object)this);
    }

    public A withEventSources(String ... eventSources) {
        if (this.eventSources != null) {
            this.eventSources.clear();
            this._visitables.remove((Object)"eventSources");
        }
        if (eventSources != null) {
            for (String item : eventSources) {
                this.addToEventSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEventSources() {
        return this.eventSources != null && !this.eventSources.isEmpty();
    }

    public Boolean getFilterEventType() {
        return this.filterEventType;
    }

    public A withFilterEventType(Boolean filterEventType) {
        this.filterEventType = filterEventType;
        return (A)((Object)this);
    }

    public boolean hasFilterEventType() {
        return this.filterEventType != null;
    }

    public Boolean getFilterSourceChannels() {
        return this.filterSourceChannels;
    }

    public A withFilterSourceChannels(Boolean filterSourceChannels) {
        this.filterSourceChannels = filterSourceChannels;
        return (A)((Object)this);
    }

    public boolean hasFilterSourceChannels() {
        return this.filterSourceChannels != null;
    }

    public A addToFilters(int index, String item) {
        if (this.filters == null) {
            this.filters = new ArrayList<String>();
        }
        this.filters.add(index, item);
        return (A)((Object)this);
    }

    public A setToFilters(int index, String item) {
        if (this.filters == null) {
            this.filters = new ArrayList<String>();
        }
        this.filters.set(index, item);
        return (A)((Object)this);
    }

    public A addToFilters(String ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList<String>();
        }
        for (String item : items) {
            this.filters.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFilters(Collection<String> items) {
        if (this.filters == null) {
            this.filters = new ArrayList<String>();
        }
        for (String item : items) {
            this.filters.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFilters(String ... items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.filters.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFilters(Collection<String> items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.filters.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public String getFilter(int index) {
        return this.filters.get(index);
    }

    public String getFirstFilter() {
        return this.filters.get(0);
    }

    public String getLastFilter() {
        return this.filters.get(this.filters.size() - 1);
    }

    public String getMatchingFilter(Predicate<String> predicate) {
        for (String item : this.filters) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<String> predicate) {
        for (String item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<String> filters) {
        if (filters != null) {
            this.filters = new ArrayList<String>();
            for (String item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)((Object)this);
    }

    public A withFilters(String ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (String item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public Boolean getNamespaceLabel() {
        return this.namespaceLabel;
    }

    public A withNamespaceLabel(Boolean namespaceLabel) {
        this.namespaceLabel = namespaceLabel;
        return (A)((Object)this);
    }

    public boolean hasNamespaceLabel() {
        return this.namespaceLabel != null;
    }

    public Boolean getSinkBinding() {
        return this.sinkBinding;
    }

    public A withSinkBinding(Boolean sinkBinding) {
        this.sinkBinding = sinkBinding;
        return (A)((Object)this);
    }

    public boolean hasSinkBinding() {
        return this.sinkBinding != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnativeFluent that = (KnativeFluent)((Object)o);
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals(this.channelSinks, that.channelSinks)) {
            return false;
        }
        if (!Objects.equals(this.channelSources, that.channelSources)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.endpointSinks, that.endpointSinks)) {
            return false;
        }
        if (!Objects.equals(this.endpointSources, that.endpointSources)) {
            return false;
        }
        if (!Objects.equals(this.eventSinks, that.eventSinks)) {
            return false;
        }
        if (!Objects.equals(this.eventSources, that.eventSources)) {
            return false;
        }
        if (!Objects.equals(this.filterEventType, that.filterEventType)) {
            return false;
        }
        if (!Objects.equals(this.filterSourceChannels, that.filterSourceChannels)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.namespaceLabel, that.namespaceLabel)) {
            return false;
        }
        return Objects.equals(this.sinkBinding, that.sinkBinding);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auto, this.channelSinks, this.channelSources, this.config, this.configuration, this.enabled, this.endpointSinks, this.endpointSources, this.eventSinks, this.eventSources, this.filterEventType, this.filterSourceChannels, this.filters, this.namespaceLabel, this.sinkBinding, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.channelSinks != null && !this.channelSinks.isEmpty()) {
            sb.append("channelSinks:");
            sb.append(this.channelSinks + ",");
        }
        if (this.channelSources != null && !this.channelSources.isEmpty()) {
            sb.append("channelSources:");
            sb.append(this.channelSources + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.endpointSinks != null && !this.endpointSinks.isEmpty()) {
            sb.append("endpointSinks:");
            sb.append(this.endpointSinks + ",");
        }
        if (this.endpointSources != null && !this.endpointSources.isEmpty()) {
            sb.append("endpointSources:");
            sb.append(this.endpointSources + ",");
        }
        if (this.eventSinks != null && !this.eventSinks.isEmpty()) {
            sb.append("eventSinks:");
            sb.append(this.eventSinks + ",");
        }
        if (this.eventSources != null && !this.eventSources.isEmpty()) {
            sb.append("eventSources:");
            sb.append(this.eventSources + ",");
        }
        if (this.filterEventType != null) {
            sb.append("filterEventType:");
            sb.append(this.filterEventType + ",");
        }
        if (this.filterSourceChannels != null) {
            sb.append("filterSourceChannels:");
            sb.append(this.filterSourceChannels + ",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.namespaceLabel != null) {
            sb.append("namespaceLabel:");
            sb.append(this.namespaceLabel + ",");
        }
        if (this.sinkBinding != null) {
            sb.append("sinkBinding:");
            sb.append(this.sinkBinding);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withFilterEventType() {
        return this.withFilterEventType(true);
    }

    public A withFilterSourceChannels() {
        return this.withFilterSourceChannels(true);
    }

    public A withNamespaceLabel() {
        return this.withNamespaceLabel(true);
    }

    public A withSinkBinding() {
        return this.withSinkBinding(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)KnativeFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

