/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.PipeSpecBuilder;
import org.apache.camel.v1.pipespec.ErrorHandler;
import org.apache.camel.v1.pipespec.Integration;
import org.apache.camel.v1.pipespec.Sink;
import org.apache.camel.v1.pipespec.Source;
import org.apache.camel.v1.pipespec.Steps;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"errorHandler", "integration", "replicas", "serviceAccountName", "sink", "source", "steps"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class PipeSpec
implements Editable<PipeSpecBuilder>,
KubernetesResource {
    @JsonProperty(value="errorHandler")
    @JsonPropertyDescription(value="ErrorHandler is an optional handler called upon an error occurring in the integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private ErrorHandler errorHandler;
    @JsonProperty(value="integration")
    @JsonPropertyDescription(value="Integration is an optional integration used to specify custom parameters Deprecated don't use this. Use trait annotations if you need to change any cluster configuration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integration integration;
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="Replicas is the number of desired replicas for the Pipe")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer replicas;
    @JsonProperty(value="serviceAccountName")
    @JsonPropertyDescription(value="Custom SA to use for the Pipe")
    @JsonSetter(nulls=Nulls.SKIP)
    private String serviceAccountName;
    @JsonProperty(value="sink")
    @JsonPropertyDescription(value="Sink is the destination of the integration defined by this Pipe")
    @JsonSetter(nulls=Nulls.SKIP)
    private Sink sink;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Source is the starting point of the integration defined by this Pipe")
    @JsonSetter(nulls=Nulls.SKIP)
    private Source source;
    @JsonProperty(value="steps")
    @JsonPropertyDescription(value="Steps contains an optional list of intermediate steps that are executed between the Source and the Sink")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Steps> steps;

    public PipeSpecBuilder edit() {
        return new PipeSpecBuilder(this);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Integration getIntegration() {
        return this.integration;
    }

    public void setIntegration(Integration integration) {
        this.integration = integration;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public Sink getSink() {
        return this.sink;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public List<Steps> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Steps> steps) {
        this.steps = steps;
    }

    public String toString() {
        return "PipeSpec(errorHandler=" + this.getErrorHandler() + ", integration=" + this.getIntegration() + ", replicas=" + this.getReplicas() + ", serviceAccountName=" + this.getServiceAccountName() + ", sink=" + this.getSink() + ", source=" + this.getSource() + ", steps=" + this.getSteps() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipeSpec)) {
            return false;
        }
        PipeSpec other = (PipeSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        ErrorHandler this$errorHandler = this.getErrorHandler();
        ErrorHandler other$errorHandler = other.getErrorHandler();
        if (this$errorHandler == null ? other$errorHandler != null : !((Object)this$errorHandler).equals(other$errorHandler)) {
            return false;
        }
        Integration this$integration = this.getIntegration();
        Integration other$integration = other.getIntegration();
        if (this$integration == null ? other$integration != null : !((Object)this$integration).equals(other$integration)) {
            return false;
        }
        String this$serviceAccountName = this.getServiceAccountName();
        String other$serviceAccountName = other.getServiceAccountName();
        if (this$serviceAccountName == null ? other$serviceAccountName != null : !this$serviceAccountName.equals(other$serviceAccountName)) {
            return false;
        }
        Sink this$sink = this.getSink();
        Sink other$sink = other.getSink();
        if (this$sink == null ? other$sink != null : !((Object)this$sink).equals(other$sink)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        List<Steps> this$steps = this.getSteps();
        List<Steps> other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PipeSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        ErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : ((Object)$errorHandler).hashCode());
        Integration $integration = this.getIntegration();
        result = result * 59 + ($integration == null ? 43 : ((Object)$integration).hashCode());
        String $serviceAccountName = this.getServiceAccountName();
        result = result * 59 + ($serviceAccountName == null ? 43 : $serviceAccountName.hashCode());
        Sink $sink = this.getSink();
        result = result * 59 + ($sink == null ? 43 : ((Object)$sink).hashCode());
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        List<Steps> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }
}

