/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.drive;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link com.google.api.services.drive.Drive.Changes}.
 */
@ApiParams(apiName = "drive-changes", 
           description = "The changes collection of methods",
           apiMethods = {@ApiMethod(methodName = "getStartPageToken", description="Gets the starting pageToken for listing future changes", signatures={"com.google.api.services.drive.Drive$Changes$GetStartPageToken getStartPageToken()"}), @ApiMethod(methodName = "list", description="Lists the changes for a user or shared drive", signatures={"com.google.api.services.drive.Drive$Changes$List list(String pageToken)"}), @ApiMethod(methodName = "watch", description="Subscribes to changes for a user", signatures={"com.google.api.services.drive.Drive$Changes$Watch watch(String pageToken, com.google.api.services.drive.model.Channel content)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
public final class DriveChangesEndpointConfiguration extends GoogleDriveConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "watch", description="The com.google.api.services.drive.model.Channel")})
    private com.google.api.services.drive.model.Channel contentChannel;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "list", description="The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response or to the response from the getStartPageToken method."), @ApiMethod(methodName = "watch", description="The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.")})
    private String pageToken;

    public com.google.api.services.drive.model.Channel getContentChannel() {
        return contentChannel;
    }

    public void setContentChannel(com.google.api.services.drive.model.Channel contentChannel) {
        this.contentChannel = contentChannel;
    }

    public String getPageToken() {
        return pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }
}
