//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to you under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v5.29.3
// source: responses.proto

package message

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Response that contains a result set.
type ResultSetResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ConnectionId string                 `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3"`
	xxx_hidden_StatementId  uint32                 `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3"`
	xxx_hidden_OwnStatement bool                   `protobuf:"varint,3,opt,name=own_statement,json=ownStatement,proto3"`
	xxx_hidden_Signature    *Signature             `protobuf:"bytes,4,opt,name=signature,proto3"`
	xxx_hidden_FirstFrame   *Frame                 `protobuf:"bytes,5,opt,name=first_frame,json=firstFrame,proto3"`
	xxx_hidden_UpdateCount  uint64                 `protobuf:"varint,6,opt,name=update_count,json=updateCount,proto3"`
	xxx_hidden_Metadata     *RpcMetadata           `protobuf:"bytes,7,opt,name=metadata,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ResultSetResponse) Reset() {
	*x = ResultSetResponse{}
	mi := &file_responses_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResultSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultSetResponse) ProtoMessage() {}

func (x *ResultSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ResultSetResponse) GetConnectionId() string {
	if x != nil {
		return x.xxx_hidden_ConnectionId
	}
	return ""
}

func (x *ResultSetResponse) GetStatementId() uint32 {
	if x != nil {
		return x.xxx_hidden_StatementId
	}
	return 0
}

func (x *ResultSetResponse) GetOwnStatement() bool {
	if x != nil {
		return x.xxx_hidden_OwnStatement
	}
	return false
}

func (x *ResultSetResponse) GetSignature() *Signature {
	if x != nil {
		return x.xxx_hidden_Signature
	}
	return nil
}

func (x *ResultSetResponse) GetFirstFrame() *Frame {
	if x != nil {
		return x.xxx_hidden_FirstFrame
	}
	return nil
}

func (x *ResultSetResponse) GetUpdateCount() uint64 {
	if x != nil {
		return x.xxx_hidden_UpdateCount
	}
	return 0
}

func (x *ResultSetResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *ResultSetResponse) SetConnectionId(v string) {
	x.xxx_hidden_ConnectionId = v
}

func (x *ResultSetResponse) SetStatementId(v uint32) {
	x.xxx_hidden_StatementId = v
}

func (x *ResultSetResponse) SetOwnStatement(v bool) {
	x.xxx_hidden_OwnStatement = v
}

func (x *ResultSetResponse) SetSignature(v *Signature) {
	x.xxx_hidden_Signature = v
}

func (x *ResultSetResponse) SetFirstFrame(v *Frame) {
	x.xxx_hidden_FirstFrame = v
}

func (x *ResultSetResponse) SetUpdateCount(v uint64) {
	x.xxx_hidden_UpdateCount = v
}

func (x *ResultSetResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *ResultSetResponse) HasSignature() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Signature != nil
}

func (x *ResultSetResponse) HasFirstFrame() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_FirstFrame != nil
}

func (x *ResultSetResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *ResultSetResponse) ClearSignature() {
	x.xxx_hidden_Signature = nil
}

func (x *ResultSetResponse) ClearFirstFrame() {
	x.xxx_hidden_FirstFrame = nil
}

func (x *ResultSetResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type ResultSetResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ConnectionId string
	StatementId  uint32
	OwnStatement bool
	Signature    *Signature
	FirstFrame   *Frame
	UpdateCount  uint64
	// with no signature nor other data.
	Metadata *RpcMetadata
}

func (b0 ResultSetResponse_builder) Build() *ResultSetResponse {
	m0 := &ResultSetResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ConnectionId = b.ConnectionId
	x.xxx_hidden_StatementId = b.StatementId
	x.xxx_hidden_OwnStatement = b.OwnStatement
	x.xxx_hidden_Signature = b.Signature
	x.xxx_hidden_FirstFrame = b.FirstFrame
	x.xxx_hidden_UpdateCount = b.UpdateCount
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to PrepareAndExecuteRequest
type ExecuteResponse struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Results          *[]*ResultSetResponse  `protobuf:"bytes,1,rep,name=results,proto3"`
	xxx_hidden_MissingStatement bool                   `protobuf:"varint,2,opt,name=missing_statement,json=missingStatement,proto3"`
	xxx_hidden_Metadata         *RpcMetadata           `protobuf:"bytes,3,opt,name=metadata,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *ExecuteResponse) Reset() {
	*x = ExecuteResponse{}
	mi := &file_responses_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteResponse) ProtoMessage() {}

func (x *ExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ExecuteResponse) GetResults() []*ResultSetResponse {
	if x != nil {
		if x.xxx_hidden_Results != nil {
			return *x.xxx_hidden_Results
		}
	}
	return nil
}

func (x *ExecuteResponse) GetMissingStatement() bool {
	if x != nil {
		return x.xxx_hidden_MissingStatement
	}
	return false
}

func (x *ExecuteResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *ExecuteResponse) SetResults(v []*ResultSetResponse) {
	x.xxx_hidden_Results = &v
}

func (x *ExecuteResponse) SetMissingStatement(v bool) {
	x.xxx_hidden_MissingStatement = v
}

func (x *ExecuteResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *ExecuteResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *ExecuteResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type ExecuteResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Results          []*ResultSetResponse
	MissingStatement bool
	Metadata         *RpcMetadata
}

func (b0 ExecuteResponse_builder) Build() *ExecuteResponse {
	m0 := &ExecuteResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Results = &b.Results
	x.xxx_hidden_MissingStatement = b.MissingStatement
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to PrepareRequest
type PrepareResponse struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Statement *StatementHandle       `protobuf:"bytes,1,opt,name=statement,proto3"`
	xxx_hidden_Metadata  *RpcMetadata           `protobuf:"bytes,2,opt,name=metadata,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *PrepareResponse) Reset() {
	*x = PrepareResponse{}
	mi := &file_responses_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrepareResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareResponse) ProtoMessage() {}

func (x *PrepareResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PrepareResponse) GetStatement() *StatementHandle {
	if x != nil {
		return x.xxx_hidden_Statement
	}
	return nil
}

func (x *PrepareResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *PrepareResponse) SetStatement(v *StatementHandle) {
	x.xxx_hidden_Statement = v
}

func (x *PrepareResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *PrepareResponse) HasStatement() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Statement != nil
}

func (x *PrepareResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *PrepareResponse) ClearStatement() {
	x.xxx_hidden_Statement = nil
}

func (x *PrepareResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type PrepareResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Statement *StatementHandle
	Metadata  *RpcMetadata
}

func (b0 PrepareResponse_builder) Build() *PrepareResponse {
	m0 := &PrepareResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Statement = b.Statement
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to FetchRequest
type FetchResponse struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Frame            *Frame                 `protobuf:"bytes,1,opt,name=frame,proto3"`
	xxx_hidden_MissingStatement bool                   `protobuf:"varint,2,opt,name=missing_statement,json=missingStatement,proto3"`
	xxx_hidden_MissingResults   bool                   `protobuf:"varint,3,opt,name=missing_results,json=missingResults,proto3"`
	xxx_hidden_Metadata         *RpcMetadata           `protobuf:"bytes,4,opt,name=metadata,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *FetchResponse) Reset() {
	*x = FetchResponse{}
	mi := &file_responses_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchResponse) ProtoMessage() {}

func (x *FetchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FetchResponse) GetFrame() *Frame {
	if x != nil {
		return x.xxx_hidden_Frame
	}
	return nil
}

func (x *FetchResponse) GetMissingStatement() bool {
	if x != nil {
		return x.xxx_hidden_MissingStatement
	}
	return false
}

func (x *FetchResponse) GetMissingResults() bool {
	if x != nil {
		return x.xxx_hidden_MissingResults
	}
	return false
}

func (x *FetchResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *FetchResponse) SetFrame(v *Frame) {
	x.xxx_hidden_Frame = v
}

func (x *FetchResponse) SetMissingStatement(v bool) {
	x.xxx_hidden_MissingStatement = v
}

func (x *FetchResponse) SetMissingResults(v bool) {
	x.xxx_hidden_MissingResults = v
}

func (x *FetchResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *FetchResponse) HasFrame() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Frame != nil
}

func (x *FetchResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *FetchResponse) ClearFrame() {
	x.xxx_hidden_Frame = nil
}

func (x *FetchResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type FetchResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Frame            *Frame
	MissingStatement bool
	MissingResults   bool
	Metadata         *RpcMetadata
}

func (b0 FetchResponse_builder) Build() *FetchResponse {
	m0 := &FetchResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Frame = b.Frame
	x.xxx_hidden_MissingStatement = b.MissingStatement
	x.xxx_hidden_MissingResults = b.MissingResults
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to CreateStatementRequest
type CreateStatementResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ConnectionId string                 `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3"`
	xxx_hidden_StatementId  uint32                 `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3"`
	xxx_hidden_Metadata     *RpcMetadata           `protobuf:"bytes,3,opt,name=metadata,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *CreateStatementResponse) Reset() {
	*x = CreateStatementResponse{}
	mi := &file_responses_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateStatementResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStatementResponse) ProtoMessage() {}

func (x *CreateStatementResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateStatementResponse) GetConnectionId() string {
	if x != nil {
		return x.xxx_hidden_ConnectionId
	}
	return ""
}

func (x *CreateStatementResponse) GetStatementId() uint32 {
	if x != nil {
		return x.xxx_hidden_StatementId
	}
	return 0
}

func (x *CreateStatementResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *CreateStatementResponse) SetConnectionId(v string) {
	x.xxx_hidden_ConnectionId = v
}

func (x *CreateStatementResponse) SetStatementId(v uint32) {
	x.xxx_hidden_StatementId = v
}

func (x *CreateStatementResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *CreateStatementResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *CreateStatementResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type CreateStatementResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ConnectionId string
	StatementId  uint32
	Metadata     *RpcMetadata
}

func (b0 CreateStatementResponse_builder) Build() *CreateStatementResponse {
	m0 := &CreateStatementResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ConnectionId = b.ConnectionId
	x.xxx_hidden_StatementId = b.StatementId
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to CloseStatementRequest
type CloseStatementResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Metadata *RpcMetadata           `protobuf:"bytes,1,opt,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CloseStatementResponse) Reset() {
	*x = CloseStatementResponse{}
	mi := &file_responses_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStatementResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStatementResponse) ProtoMessage() {}

func (x *CloseStatementResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CloseStatementResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *CloseStatementResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *CloseStatementResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *CloseStatementResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type CloseStatementResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Metadata *RpcMetadata
}

func (b0 CloseStatementResponse_builder) Build() *CloseStatementResponse {
	m0 := &CloseStatementResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to OpenConnectionRequest {
type OpenConnectionResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Metadata *RpcMetadata           `protobuf:"bytes,1,opt,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *OpenConnectionResponse) Reset() {
	*x = OpenConnectionResponse{}
	mi := &file_responses_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenConnectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenConnectionResponse) ProtoMessage() {}

func (x *OpenConnectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OpenConnectionResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *OpenConnectionResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *OpenConnectionResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *OpenConnectionResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type OpenConnectionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Metadata *RpcMetadata
}

func (b0 OpenConnectionResponse_builder) Build() *OpenConnectionResponse {
	m0 := &OpenConnectionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to CloseConnectionRequest {
type CloseConnectionResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Metadata *RpcMetadata           `protobuf:"bytes,1,opt,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CloseConnectionResponse) Reset() {
	*x = CloseConnectionResponse{}
	mi := &file_responses_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseConnectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseConnectionResponse) ProtoMessage() {}

func (x *CloseConnectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CloseConnectionResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *CloseConnectionResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *CloseConnectionResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *CloseConnectionResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type CloseConnectionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Metadata *RpcMetadata
}

func (b0 CloseConnectionResponse_builder) Build() *CloseConnectionResponse {
	m0 := &CloseConnectionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response to ConnectionSyncRequest
type ConnectionSyncResponse struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ConnProps *ConnectionProperties  `protobuf:"bytes,1,opt,name=conn_props,json=connProps,proto3"`
	xxx_hidden_Metadata  *RpcMetadata           `protobuf:"bytes,2,opt,name=metadata,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ConnectionSyncResponse) Reset() {
	*x = ConnectionSyncResponse{}
	mi := &file_responses_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionSyncResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSyncResponse) ProtoMessage() {}

func (x *ConnectionSyncResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ConnectionSyncResponse) GetConnProps() *ConnectionProperties {
	if x != nil {
		return x.xxx_hidden_ConnProps
	}
	return nil
}

func (x *ConnectionSyncResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *ConnectionSyncResponse) SetConnProps(v *ConnectionProperties) {
	x.xxx_hidden_ConnProps = v
}

func (x *ConnectionSyncResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *ConnectionSyncResponse) HasConnProps() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ConnProps != nil
}

func (x *ConnectionSyncResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *ConnectionSyncResponse) ClearConnProps() {
	x.xxx_hidden_ConnProps = nil
}

func (x *ConnectionSyncResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type ConnectionSyncResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ConnProps *ConnectionProperties
	Metadata  *RpcMetadata
}

func (b0 ConnectionSyncResponse_builder) Build() *ConnectionSyncResponse {
	m0 := &ConnectionSyncResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ConnProps = b.ConnProps
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

type DatabasePropertyElement struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Key      *DatabaseProperty      `protobuf:"bytes,1,opt,name=key,proto3"`
	xxx_hidden_Value    *TypedValue            `protobuf:"bytes,2,opt,name=value,proto3"`
	xxx_hidden_Metadata *RpcMetadata           `protobuf:"bytes,3,opt,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DatabasePropertyElement) Reset() {
	*x = DatabasePropertyElement{}
	mi := &file_responses_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabasePropertyElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabasePropertyElement) ProtoMessage() {}

func (x *DatabasePropertyElement) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DatabasePropertyElement) GetKey() *DatabaseProperty {
	if x != nil {
		return x.xxx_hidden_Key
	}
	return nil
}

func (x *DatabasePropertyElement) GetValue() *TypedValue {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return nil
}

func (x *DatabasePropertyElement) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *DatabasePropertyElement) SetKey(v *DatabaseProperty) {
	x.xxx_hidden_Key = v
}

func (x *DatabasePropertyElement) SetValue(v *TypedValue) {
	x.xxx_hidden_Value = v
}

func (x *DatabasePropertyElement) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *DatabasePropertyElement) HasKey() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Key != nil
}

func (x *DatabasePropertyElement) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *DatabasePropertyElement) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *DatabasePropertyElement) ClearKey() {
	x.xxx_hidden_Key = nil
}

func (x *DatabasePropertyElement) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *DatabasePropertyElement) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type DatabasePropertyElement_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Key      *DatabaseProperty
	Value    *TypedValue
	Metadata *RpcMetadata
}

func (b0 DatabasePropertyElement_builder) Build() *DatabasePropertyElement {
	m0 := &DatabasePropertyElement{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Key = b.Key
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Response for Meta#getDatabaseProperties()
type DatabasePropertyResponse struct {
	state               protoimpl.MessageState      `protogen:"opaque.v1"`
	xxx_hidden_Props    *[]*DatabasePropertyElement `protobuf:"bytes,1,rep,name=props,proto3"`
	xxx_hidden_Metadata *RpcMetadata                `protobuf:"bytes,2,opt,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DatabasePropertyResponse) Reset() {
	*x = DatabasePropertyResponse{}
	mi := &file_responses_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabasePropertyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabasePropertyResponse) ProtoMessage() {}

func (x *DatabasePropertyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DatabasePropertyResponse) GetProps() []*DatabasePropertyElement {
	if x != nil {
		if x.xxx_hidden_Props != nil {
			return *x.xxx_hidden_Props
		}
	}
	return nil
}

func (x *DatabasePropertyResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *DatabasePropertyResponse) SetProps(v []*DatabasePropertyElement) {
	x.xxx_hidden_Props = &v
}

func (x *DatabasePropertyResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *DatabasePropertyResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *DatabasePropertyResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type DatabasePropertyResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Props    []*DatabasePropertyElement
	Metadata *RpcMetadata
}

func (b0 DatabasePropertyResponse_builder) Build() *DatabasePropertyResponse {
	m0 := &DatabasePropertyResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Props = &b.Props
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Send contextual information about some error over the wire from the server.
type ErrorResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Exceptions    []string               `protobuf:"bytes,1,rep,name=exceptions,proto3"`
	xxx_hidden_HasExceptions bool                   `protobuf:"varint,7,opt,name=has_exceptions,json=hasExceptions,proto3"`
	xxx_hidden_ErrorMessage  string                 `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3"`
	xxx_hidden_Severity      Severity               `protobuf:"varint,3,opt,name=severity,proto3,enum=Severity"`
	xxx_hidden_ErrorCode     uint32                 `protobuf:"varint,4,opt,name=error_code,json=errorCode,proto3"`
	xxx_hidden_SqlState      string                 `protobuf:"bytes,5,opt,name=sql_state,json=sqlState,proto3"`
	xxx_hidden_Metadata      *RpcMetadata           `protobuf:"bytes,6,opt,name=metadata,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ErrorResponse) Reset() {
	*x = ErrorResponse{}
	mi := &file_responses_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ErrorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorResponse) ProtoMessage() {}

func (x *ErrorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ErrorResponse) GetExceptions() []string {
	if x != nil {
		return x.xxx_hidden_Exceptions
	}
	return nil
}

func (x *ErrorResponse) GetHasExceptions() bool {
	if x != nil {
		return x.xxx_hidden_HasExceptions
	}
	return false
}

func (x *ErrorResponse) GetErrorMessage() string {
	if x != nil {
		return x.xxx_hidden_ErrorMessage
	}
	return ""
}

func (x *ErrorResponse) GetSeverity() Severity {
	if x != nil {
		return x.xxx_hidden_Severity
	}
	return Severity_UNKNOWN_SEVERITY
}

func (x *ErrorResponse) GetErrorCode() uint32 {
	if x != nil {
		return x.xxx_hidden_ErrorCode
	}
	return 0
}

func (x *ErrorResponse) GetSqlState() string {
	if x != nil {
		return x.xxx_hidden_SqlState
	}
	return ""
}

func (x *ErrorResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *ErrorResponse) SetExceptions(v []string) {
	x.xxx_hidden_Exceptions = v
}

func (x *ErrorResponse) SetHasExceptions(v bool) {
	x.xxx_hidden_HasExceptions = v
}

func (x *ErrorResponse) SetErrorMessage(v string) {
	x.xxx_hidden_ErrorMessage = v
}

func (x *ErrorResponse) SetSeverity(v Severity) {
	x.xxx_hidden_Severity = v
}

func (x *ErrorResponse) SetErrorCode(v uint32) {
	x.xxx_hidden_ErrorCode = v
}

func (x *ErrorResponse) SetSqlState(v string) {
	x.xxx_hidden_SqlState = v
}

func (x *ErrorResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *ErrorResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *ErrorResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type ErrorResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Exceptions    []string
	HasExceptions bool
	ErrorMessage  string
	Severity      Severity
	ErrorCode     uint32
	SqlState      string
	Metadata      *RpcMetadata
}

func (b0 ErrorResponse_builder) Build() *ErrorResponse {
	m0 := &ErrorResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Exceptions = b.Exceptions
	x.xxx_hidden_HasExceptions = b.HasExceptions
	x.xxx_hidden_ErrorMessage = b.ErrorMessage
	x.xxx_hidden_Severity = b.Severity
	x.xxx_hidden_ErrorCode = b.ErrorCode
	x.xxx_hidden_SqlState = b.SqlState
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

type SyncResultsResponse struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_MissingStatement bool                   `protobuf:"varint,1,opt,name=missing_statement,json=missingStatement,proto3"`
	xxx_hidden_MoreResults      bool                   `protobuf:"varint,2,opt,name=more_results,json=moreResults,proto3"`
	xxx_hidden_Metadata         *RpcMetadata           `protobuf:"bytes,3,opt,name=metadata,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *SyncResultsResponse) Reset() {
	*x = SyncResultsResponse{}
	mi := &file_responses_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncResultsResponse) ProtoMessage() {}

func (x *SyncResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SyncResultsResponse) GetMissingStatement() bool {
	if x != nil {
		return x.xxx_hidden_MissingStatement
	}
	return false
}

func (x *SyncResultsResponse) GetMoreResults() bool {
	if x != nil {
		return x.xxx_hidden_MoreResults
	}
	return false
}

func (x *SyncResultsResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *SyncResultsResponse) SetMissingStatement(v bool) {
	x.xxx_hidden_MissingStatement = v
}

func (x *SyncResultsResponse) SetMoreResults(v bool) {
	x.xxx_hidden_MoreResults = v
}

func (x *SyncResultsResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *SyncResultsResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *SyncResultsResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type SyncResultsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	MissingStatement bool
	MoreResults      bool
	Metadata         *RpcMetadata
}

func (b0 SyncResultsResponse_builder) Build() *SyncResultsResponse {
	m0 := &SyncResultsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_MissingStatement = b.MissingStatement
	x.xxx_hidden_MoreResults = b.MoreResults
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Generic metadata for the server to return with each response.
type RpcMetadata struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ServerAddress string                 `protobuf:"bytes,1,opt,name=server_address,json=serverAddress,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *RpcMetadata) Reset() {
	*x = RpcMetadata{}
	mi := &file_responses_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RpcMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RpcMetadata) ProtoMessage() {}

func (x *RpcMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RpcMetadata) GetServerAddress() string {
	if x != nil {
		return x.xxx_hidden_ServerAddress
	}
	return ""
}

func (x *RpcMetadata) SetServerAddress(v string) {
	x.xxx_hidden_ServerAddress = v
}

type RpcMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ServerAddress string
}

func (b0 RpcMetadata_builder) Build() *RpcMetadata {
	m0 := &RpcMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ServerAddress = b.ServerAddress
	return m0
}

// Response to a commit request
type CommitResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	mi := &file_responses_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type CommitResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 CommitResponse_builder) Build() *CommitResponse {
	m0 := &CommitResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// Response to a rollback request
type RollbackResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RollbackResponse) Reset() {
	*x = RollbackResponse{}
	mi := &file_responses_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RollbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackResponse) ProtoMessage() {}

func (x *RollbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RollbackResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RollbackResponse_builder) Build() *RollbackResponse {
	m0 := &RollbackResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// Response to a batch update request
type ExecuteBatchResponse struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ConnectionId     string                 `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3"`
	xxx_hidden_StatementId      uint32                 `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3"`
	xxx_hidden_UpdateCounts     []uint64               `protobuf:"varint,3,rep,packed,name=update_counts,json=updateCounts,proto3"`
	xxx_hidden_MissingStatement bool                   `protobuf:"varint,4,opt,name=missing_statement,json=missingStatement,proto3"`
	xxx_hidden_Metadata         *RpcMetadata           `protobuf:"bytes,5,opt,name=metadata,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *ExecuteBatchResponse) Reset() {
	*x = ExecuteBatchResponse{}
	mi := &file_responses_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteBatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchResponse) ProtoMessage() {}

func (x *ExecuteBatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_responses_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ExecuteBatchResponse) GetConnectionId() string {
	if x != nil {
		return x.xxx_hidden_ConnectionId
	}
	return ""
}

func (x *ExecuteBatchResponse) GetStatementId() uint32 {
	if x != nil {
		return x.xxx_hidden_StatementId
	}
	return 0
}

func (x *ExecuteBatchResponse) GetUpdateCounts() []uint64 {
	if x != nil {
		return x.xxx_hidden_UpdateCounts
	}
	return nil
}

func (x *ExecuteBatchResponse) GetMissingStatement() bool {
	if x != nil {
		return x.xxx_hidden_MissingStatement
	}
	return false
}

func (x *ExecuteBatchResponse) GetMetadata() *RpcMetadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *ExecuteBatchResponse) SetConnectionId(v string) {
	x.xxx_hidden_ConnectionId = v
}

func (x *ExecuteBatchResponse) SetStatementId(v uint32) {
	x.xxx_hidden_StatementId = v
}

func (x *ExecuteBatchResponse) SetUpdateCounts(v []uint64) {
	x.xxx_hidden_UpdateCounts = v
}

func (x *ExecuteBatchResponse) SetMissingStatement(v bool) {
	x.xxx_hidden_MissingStatement = v
}

func (x *ExecuteBatchResponse) SetMetadata(v *RpcMetadata) {
	x.xxx_hidden_Metadata = v
}

func (x *ExecuteBatchResponse) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *ExecuteBatchResponse) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type ExecuteBatchResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ConnectionId     string
	StatementId      uint32
	UpdateCounts     []uint64
	MissingStatement bool
	Metadata         *RpcMetadata
}

func (b0 ExecuteBatchResponse_builder) Build() *ExecuteBatchResponse {
	m0 := &ExecuteBatchResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ConnectionId = b.ConnectionId
	x.xxx_hidden_StatementId = b.StatementId
	x.xxx_hidden_UpdateCounts = b.UpdateCounts
	x.xxx_hidden_MissingStatement = b.MissingStatement
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

var File_responses_proto protoreflect.FileDescriptor

var file_responses_proto_rawDesc = string([]byte{
	0x0a, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xa0, 0x02, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x6f, 0x77, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6f, 0x77, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x28, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x27, 0x0a, 0x0b,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x06, 0x2e, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x0a, 0x66, 0x69, 0x72, 0x73, 0x74,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x96, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x6b, 0x0a, 0x0f, 0x50,
	0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e,
	0x0a, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x28,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xad, 0x01, 0x0a, 0x0d, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x05, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x06, 0x2e, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x52, 0x05, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x28,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8b, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c,
	0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x42, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x42, 0x0a, 0x16, 0x4f, 0x70,
	0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x43,
	0x0a, 0x17, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70,
	0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x78, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x50, 0x72,
	0x6f, 0x70, 0x73, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8b, 0x01,
	0x0a, 0x17, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x21,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x74, 0x0a, 0x18, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x70, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x05, 0x70, 0x72, 0x6f, 0x70, 0x73, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x88, 0x02, 0x0a, 0x0d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x68, 0x61, 0x73, 0x5f, 0x65, 0x78, 0x63, 0x65, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61, 0x73,
	0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x25, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x09, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x71, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8f, 0x01, 0x0a,
	0x13, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6d, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x34,
	0x0a, 0x0b, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x22, 0x10, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x12, 0x0a, 0x10, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x14, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x04, 0x52, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0c, 0x2e, 0x52, 0x70, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x22, 0x0a, 0x20, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x63, 0x61, 0x6c, 0x63, 0x69, 0x74, 0x65, 0x2e, 0x61, 0x76,
	0x61, 0x74, 0x69, 0x63, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
})

var file_responses_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_responses_proto_goTypes = []any{
	(*ResultSetResponse)(nil),        // 0: ResultSetResponse
	(*ExecuteResponse)(nil),          // 1: ExecuteResponse
	(*PrepareResponse)(nil),          // 2: PrepareResponse
	(*FetchResponse)(nil),            // 3: FetchResponse
	(*CreateStatementResponse)(nil),  // 4: CreateStatementResponse
	(*CloseStatementResponse)(nil),   // 5: CloseStatementResponse
	(*OpenConnectionResponse)(nil),   // 6: OpenConnectionResponse
	(*CloseConnectionResponse)(nil),  // 7: CloseConnectionResponse
	(*ConnectionSyncResponse)(nil),   // 8: ConnectionSyncResponse
	(*DatabasePropertyElement)(nil),  // 9: DatabasePropertyElement
	(*DatabasePropertyResponse)(nil), // 10: DatabasePropertyResponse
	(*ErrorResponse)(nil),            // 11: ErrorResponse
	(*SyncResultsResponse)(nil),      // 12: SyncResultsResponse
	(*RpcMetadata)(nil),              // 13: RpcMetadata
	(*CommitResponse)(nil),           // 14: CommitResponse
	(*RollbackResponse)(nil),         // 15: RollbackResponse
	(*ExecuteBatchResponse)(nil),     // 16: ExecuteBatchResponse
	(*Signature)(nil),                // 17: Signature
	(*Frame)(nil),                    // 18: Frame
	(*StatementHandle)(nil),          // 19: StatementHandle
	(*ConnectionProperties)(nil),     // 20: ConnectionProperties
	(*DatabaseProperty)(nil),         // 21: DatabaseProperty
	(*TypedValue)(nil),               // 22: TypedValue
	(Severity)(0),                    // 23: Severity
}
var file_responses_proto_depIdxs = []int32{
	17, // 0: ResultSetResponse.signature:type_name -> Signature
	18, // 1: ResultSetResponse.first_frame:type_name -> Frame
	13, // 2: ResultSetResponse.metadata:type_name -> RpcMetadata
	0,  // 3: ExecuteResponse.results:type_name -> ResultSetResponse
	13, // 4: ExecuteResponse.metadata:type_name -> RpcMetadata
	19, // 5: PrepareResponse.statement:type_name -> StatementHandle
	13, // 6: PrepareResponse.metadata:type_name -> RpcMetadata
	18, // 7: FetchResponse.frame:type_name -> Frame
	13, // 8: FetchResponse.metadata:type_name -> RpcMetadata
	13, // 9: CreateStatementResponse.metadata:type_name -> RpcMetadata
	13, // 10: CloseStatementResponse.metadata:type_name -> RpcMetadata
	13, // 11: OpenConnectionResponse.metadata:type_name -> RpcMetadata
	13, // 12: CloseConnectionResponse.metadata:type_name -> RpcMetadata
	20, // 13: ConnectionSyncResponse.conn_props:type_name -> ConnectionProperties
	13, // 14: ConnectionSyncResponse.metadata:type_name -> RpcMetadata
	21, // 15: DatabasePropertyElement.key:type_name -> DatabaseProperty
	22, // 16: DatabasePropertyElement.value:type_name -> TypedValue
	13, // 17: DatabasePropertyElement.metadata:type_name -> RpcMetadata
	9,  // 18: DatabasePropertyResponse.props:type_name -> DatabasePropertyElement
	13, // 19: DatabasePropertyResponse.metadata:type_name -> RpcMetadata
	23, // 20: ErrorResponse.severity:type_name -> Severity
	13, // 21: ErrorResponse.metadata:type_name -> RpcMetadata
	13, // 22: SyncResultsResponse.metadata:type_name -> RpcMetadata
	13, // 23: ExecuteBatchResponse.metadata:type_name -> RpcMetadata
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_responses_proto_init() }
func file_responses_proto_init() {
	if File_responses_proto != nil {
		return
	}
	file_common_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_responses_proto_rawDesc), len(file_responses_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_responses_proto_goTypes,
		DependencyIndexes: file_responses_proto_depIdxs,
		MessageInfos:      file_responses_proto_msgTypes,
	}.Build()
	File_responses_proto = out.File
	file_responses_proto_goTypes = nil
	file_responses_proto_depIdxs = nil
}
