/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public interface AddSensorInitializerAbstractProto<T>
extends EntityInitializer {
    public static final ConfigKey<String> SENSOR_NAME = ConfigKeys.newStringConfigKey("name", "The name of the sensor to create");
    public static final ConfigKey<Duration> SENSOR_PERIOD = ConfigKeys.newConfigKey(Duration.class, "period", "Period, including units e.g. 1m or 5s or 200ms; default 5 minutes", Duration.FIVE_MINUTES);
    public static final ConfigKey<String> SENSOR_TYPE = ConfigKeys.newStringConfigKey("targetType", "Target type for the value; default String", "java.lang.String");
    public static final Logger LOG = LoggerFactory.getLogger(AddSensorInitializerAbstractProto.class);

    @Beta
    public static <T> TypeToken<T> getType(Entity entity, String className, String name) {
        try {
            return new BrooklynTypeNameResolution.BrooklynTypeNameResolver("sensor " + name + " on " + entity, RegisteredTypes.getClassLoadingContext(entity), true, true).getTypeToken(className);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Unable to resolve type " + className + " for sensor " + name + " on " + entity + " (rethrowing)");
            throw Exceptions.propagateAnnotated((String)("Unable to resolve type " + className + " for sensor " + name + " " + e), (Throwable)e);
        }
    }
}

