/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.config.SetConfigKey;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Beta
public interface ChefConfig {
    public static final ConfigKey<String> CHEF_COOKBOOK_PRIMARY_NAME = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.cookbook.primary.name", (String)"Namespace to use for passing data to Chef and for finding effectors");
    @SetFromFlag(value="cookbook_urls")
    public static final MapConfigKey<String> CHEF_COOKBOOK_URLS = new MapConfigKey(String.class, "brooklyn.chef.cookbooksUrls");
    @SetFromFlag(value="converge_twice")
    public static final ConfigKey<Boolean> CHEF_RUN_CONVERGE_TWICE = ConfigKeys.newBooleanConfigKey((String)"brooklyn.chef.converge.twice", (String)"Whether to run converge commands twice if the first one fails; needed in some contexts, e.g. when switching between chef-server and chef-solo mode", (Boolean)false);
    @Deprecated
    public static final SetConfigKey<String> CHEF_RUN_LIST = new SetConfigKey(String.class, "brooklyn.chef.runList");
    @SetFromFlag(value="launch_run_list")
    public static final SetConfigKey<String> CHEF_LAUNCH_RUN_LIST = new SetConfigKey(String.class, "brooklyn.chef.launch.runList");
    @SetFromFlag(value="launch_attributes")
    public static final MapConfigKey<Object> CHEF_LAUNCH_ATTRIBUTES = new MapConfigKey(Object.class, "brooklyn.chef.launch.attributes");
    @SetFromFlag(value="chef_mode")
    public static final ConfigKey<ChefModes> CHEF_MODE = ConfigKeys.newConfigKey(ChefModes.class, (String)"brooklyn.chef.mode", (String)"Whether Chef should run in solo mode, knife mode, or auto-detect", (Object)((Object)ChefModes.AUTODETECT));
    public static final ConfigKey<String> KNIFE_SETUP_COMMANDS = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.knife.setupCommands", (String)"An optional set of commands to run on localhost before invoking knife; useful if using ruby version manager for example");
    public static final ConfigKey<String> KNIFE_EXECUTABLE = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.knife.executableFile", (String)"Knife command to run on the Brooklyn machine, including full path; defaults to scanning the path");
    public static final ConfigKey<String> KNIFE_CONFIG_FILE = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.knife.configFile", (String)"Knife config file (typically knife.rb) to use, including full path; defaults to knife default/global config");
    @SetFromFlag(value="chef_node_name")
    public static final ConfigKey<String> CHEF_NODE_NAME = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.node.nodeName", (String)"Node name to register with the chef server for this entity, if using Chef server and a specific node name is desired; if supplied ,this must be unique across the nodes Chef Server manages; if not supplied, one will be created if needed");
    @SetFromFlag(value="pid_file")
    public static final ConfigKey<String> PID_FILE = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.lifecycle.pidFile", (String)"Path to PID file on remote machine, for use in checking running and stopping; may contain wildcards");
    @SetFromFlag(value="service_name")
    public static final ConfigKey<String> SERVICE_NAME = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.lifecycle.serviceName", (String)"Name of OS service this will run as, for use in checking running and stopping");
    @SetFromFlag(value="windows_service_name")
    public static final ConfigKey<String> WINDOWS_SERVICE_NAME = ConfigKeys.newStringConfigKey((String)"brooklyn.chef.lifecycle.windowsServiceName", (String)"Name of OS service this will run as on Windows, if different there, for use in checking running and stopping");

    public static enum ChefModes {
        SOLO,
        KNIFE,
        AUTODETECT;

    }
}

