/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.yaml;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.internal.BrooklynSystemProperties;
import org.apache.brooklyn.util.javalang.coerce.PrimitiveStringTypeCoercions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class Yamls {
    private static final Logger log = LoggerFactory.getLogger(Yamls.class);
    private static final LastDocumentFunction LAST_DOCUMENT_FUNCTION_INSTANCE = new LastDocumentFunction();

    private static Yaml newYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        if (BrooklynSystemProperties.YAML_TYPE_INSTANTIATION.isEnabled()) {
            loaderOptions.setTagInspector(new TagInspector(){

                public boolean isGlobalTagAllowed(Tag tag) {
                    return true;
                }
            });
        }
        return new Yaml((BaseConstructor)(BrooklynSystemProperties.YAML_TYPE_INSTANTIATION.isEnabled() ? new ConstructorExcludingNonNumbers(loaderOptions) : new SafeConstructorExcludingNonNumbers(loaderOptions)));
    }

    private static Object numericDoublesOnly(Object construct, Node node) {
        if (PrimitiveStringTypeCoercions.isNanOrInf(construct)) {
            throw new IllegalStateException("YAML parser forbids out of range doubles; consider wrapping as string and coercing to type BigDecimal: " + node);
        }
        return construct;
    }

    public static <T> T getAs(Object x, Class<T> type) {
        if (x == null) {
            return null;
        }
        if (x instanceof Iterable || x instanceof Iterator) {
            ArrayList result = new ArrayList();
            Iterator xi = Iterator.class.isAssignableFrom(x.getClass()) ? (Iterator)x : ((Iterable)x).iterator();
            while (xi.hasNext()) {
                result.add(xi.next());
            }
            if (type.isAssignableFrom(List.class)) {
                return (T)result;
            }
            if (type.isAssignableFrom(Iterator.class)) {
                return (T)result.iterator();
            }
            x = Iterables.getOnlyElement(result);
        }
        if (type.isInstance(x)) {
            return (T)x;
        }
        throw new ClassCastException("Cannot convert " + x + " (" + x.getClass() + ") to " + type);
    }

    @Beta
    public static Object getAt(String yaml, List<String> path) {
        Iterable result = Yamls.newYaml().loadAll(yaml);
        Object current = result.iterator().next();
        return Yamls.getAtPreParsed(current, path);
    }

    @Beta
    public static Object getAtPreParsed(Object current, List<String> path) {
        for (String pathPart : path) {
            if (pathPart.startsWith("[") && pathPart.endsWith("]")) {
                String index = pathPart.substring(1, pathPart.length() - 1);
                try {
                    current = Iterables.get((Iterable)((Iterable)current), (int)Integer.parseInt(index));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid index '" + index + "', in path " + path);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Invalid index '" + index + "', in path " + path);
                }
            } else {
                current = ((Map)current).get(pathPart);
            }
            if (current != null) continue;
            return null;
        }
        return current;
    }

    public static void dump(int depth, Object r) {
        if (r instanceof Iterable) {
            for (Object ri : (Iterable)r) {
                Yamls.dump(depth + 1, ri);
            }
        } else if (r instanceof Map) {
            for (Map.Entry re : ((Map)r).entrySet()) {
                for (int i = 0; i < depth; ++i) {
                    System.out.print(" ");
                }
                System.out.println(re.getKey() + ":");
                Yamls.dump(depth + 1, re.getValue());
            }
        } else {
            for (int i = 0; i < depth; ++i) {
                System.out.print(" ");
            }
            if (r == null) {
                System.out.println("<null>");
            } else {
                System.out.println("<" + r.getClass().getSimpleName() + "> " + r);
            }
        }
    }

    public static Iterable<Object> parseAll(String yaml) {
        Iterable result = Yamls.newYaml().loadAll(yaml);
        return Yamls.getAs(result, List.class);
    }

    public static Iterable<Object> parseAll(Reader yaml) {
        Iterable result = Yamls.newYaml().loadAll(yaml);
        return Yamls.getAs(result, List.class);
    }

    public static Object removeMultinameAttribute(Map<String, Object> obj, String ... equivalentNames) {
        Object result = null;
        for (String name : equivalentNames) {
            Object candidate = obj.remove(name);
            if (candidate == null) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            if (result.equals(candidate)) continue;
            log.warn("Different values for attributes " + Arrays.toString(equivalentNames) + "; preferring '" + result + "' to '" + candidate + "'");
        }
        return result;
    }

    public static Object getMultinameAttribute(Map<String, Object> obj, String ... equivalentNames) {
        Object result = null;
        for (String name : equivalentNames) {
            Object candidate = obj.get(name);
            if (candidate == null) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            if (result.equals(candidate)) continue;
            log.warn("Different values for attributes " + Arrays.toString(equivalentNames) + "; preferring '" + result + "' to '" + candidate + "'");
        }
        return result;
    }

    private static void findTextOfYamlAtPath(YamlExtract result, int pathIndex, Object ... path) {
        if (pathIndex >= path.length) {
            return;
        }
        Object pathItem = path[pathIndex];
        Node node = result.focus;
        if (node.getNodeId() == NodeId.mapping && pathItem instanceof String) {
            Iterator ti = ((MappingNode)node).getValue().iterator();
            while (ti.hasNext()) {
                NodeTuple t = (NodeTuple)ti.next();
                Node key = t.getKeyNode();
                if (key.getNodeId() == NodeId.scalar) {
                    if (pathItem.equals(((ScalarNode)key).getValue())) {
                        result.key = key;
                        result.focus = t.getValueNode();
                        if (pathIndex + 1 < path.length) {
                            result.prev = key;
                        } else {
                            result.focusTuple = t;
                        }
                        Yamls.findTextOfYamlAtPath(result, pathIndex + 1, path);
                        if (result.next == null && ti.hasNext()) {
                            result.next = ((NodeTuple)ti.next()).getKeyNode();
                        }
                        return;
                    }
                    result.prev = t.getValueNode();
                    continue;
                }
                throw new IllegalStateException("Key " + key + " is not a scalar, searching for " + pathItem + " at depth " + pathIndex + " of " + Arrays.asList(path));
            }
            throw new IllegalStateException("Did not find " + pathItem + " in " + node + " at depth " + pathIndex + " of " + Arrays.asList(path));
        }
        if (node.getNodeId() == NodeId.sequence && pathItem instanceof Number) {
            List nl = ((SequenceNode)node).getValue();
            int i = ((Number)pathItem).intValue();
            if (i >= nl.size()) {
                throw new IllegalStateException("Index " + i + " is out of bounds in " + node + ", searching for " + pathItem + " at depth " + pathIndex + " of " + Arrays.asList(path));
            }
            if (i > 0) {
                result.prev = (Node)nl.get(i - 1);
            }
            result.key = null;
            result.focus = (Node)nl.get(i);
            Yamls.findTextOfYamlAtPath(result, pathIndex + 1, path);
            if (result.next == null && nl.size() > i + 1) {
                result.next = (Node)nl.get(i + 1);
            }
            return;
        }
        throw new IllegalStateException("Node " + node + " does not match selector " + pathItem + " at depth " + pathIndex + " of " + Arrays.asList(path));
    }

    public static YamlExtract getTextOfYamlAtPath(String yaml, Object ... path) {
        YamlExtract result = new YamlExtract();
        if (yaml == null) {
            return result;
        }
        try {
            int pathIndex = 0;
            result.yaml = yaml;
            result.focus = Yamls.newYaml().compose((Reader)new StringReader(yaml));
            Yamls.findTextOfYamlAtPath(result, pathIndex, path);
            return result;
        }
        catch (NoSuchMethodError e) {
            throw new IllegalStateException("Class version error. This can happen if using a TestNG plugin in your IDE which is an older version, dragging in an older version of SnakeYAML which does not support Mark.getIndex.", e);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            if (log.isTraceEnabled()) {
                log.trace("Unable to find element in yaml (setting in result): " + e);
            }
            result.error = e;
            return result;
        }
    }

    public static Function<String, String> lastDocumentFunction() {
        return LAST_DOCUMENT_FUNCTION_INSTANCE;
    }

    static class LastDocumentFunction
    implements Function<String, String> {
        LastDocumentFunction() {
        }

        public String apply(String input) {
            if (input == null) {
                return null;
            }
            Matcher match = Pattern.compile("^---$[\\n\\r]?", 8).matcher(input);
            int lastEnd = 0;
            while (match.find()) {
                lastEnd = match.end();
            }
            return input.substring(lastEnd);
        }
    }

    @Beta
    public static class YamlExtract {
        String yaml;
        NodeTuple focusTuple;
        Node prev;
        Node key;
        Node focus;
        Node next;
        Exception error;
        boolean includeKey = false;
        boolean includePrecedingComments = true;
        boolean includeOriginalIndentation = false;
        static AtomicBoolean LOGGED_TESTNG_WARNING = new AtomicBoolean();

        private int indexStart(Node node, boolean defaultIsYamlEnd) {
            if (node == null) {
                return defaultIsYamlEnd ? this.yaml.length() : 0;
            }
            return this.index(node.getStartMark());
        }

        private int indexEnd(Node node, boolean defaultIsYamlEnd) {
            if (!this.found() || node == null) {
                return defaultIsYamlEnd ? this.yaml.length() : 0;
            }
            return this.index(node.getEndMark());
        }

        private int index(Mark mark) {
            try {
                return mark.getIndex();
            }
            catch (NoSuchMethodError e) {
                try {
                    this.getClass().getClassLoader().loadClass("org.testng.TestNG");
                }
                catch (ClassNotFoundException e1) {
                    Exceptions.propagateIfFatal(e1);
                    throw e;
                }
                if (!LOGGED_TESTNG_WARNING.getAndSet(true)) {
                    log.warn("Detected TestNG/SnakeYAML version incompatibilities: some YAML source reconstruction will be unavailable. This can happen with TestNG plugins which force an older version of SnakeYAML which does not support Mark.getIndex. It should not occur from maven CLI runs. (Subsequent occurrences will be silently dropped, and source code reconstructed from YAML.)");
                }
                throw new KnownClassVersionException(e);
            }
        }

        public int getEndOfPrevious() {
            return this.indexEnd(this.prev, false);
        }

        @Nullable
        public Node getKey() {
            return this.key;
        }

        public Node getResult() {
            return this.focus;
        }

        public int getStartOfThis() {
            if (this.includeKey && this.focusTuple != null) {
                return this.indexStart(this.focusTuple.getKeyNode(), false);
            }
            return this.indexStart(this.focus, false);
        }

        private int getStartColumnOfThis() {
            if (this.includeKey && this.focusTuple != null) {
                return this.focusTuple.getKeyNode().getStartMark().getColumn();
            }
            return this.focus.getStartMark().getColumn();
        }

        public int getEndOfThis() {
            return this.getEndOfThis(false);
        }

        private int getEndOfThis(boolean goToEndIfNoNext) {
            if (this.next == null && goToEndIfNoNext) {
                return this.yaml.length();
            }
            return this.indexEnd(this.focus, false);
        }

        public int getStartOfNext() {
            return this.indexStart(this.next, true);
        }

        private static int initialWhitespaceLength(String x) {
            int i;
            for (i = 0; i < x.length() && x.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        public String getFullYamlTextOriginal() {
            return this.yaml;
        }

        public String getFullYamlTextWithExtractReplaced(String replacement) {
            if (!this.found()) {
                throw new IllegalStateException("Cannot perform replacement when item was not matched.");
            }
            String result = this.yaml.substring(0, this.getStartOfThis());
            String[] newLines = replacement.split("\n");
            for (int i = 1; i < newLines.length; ++i) {
                newLines[i] = Strings.makePaddedString("", this.getStartColumnOfThis(), "", " ") + newLines[i];
            }
            result = result + Strings.lines(newLines);
            if (replacement.endsWith("\n")) {
                result = result + "\n";
            }
            int end = this.getEndOfThis();
            result = result + this.yaml.substring(end);
            return result;
        }

        public YamlExtract withKeyIncluded(boolean includeKey) {
            this.includeKey = includeKey;
            return this;
        }

        public YamlExtract withPrecedingCommentsIncluded(boolean includePrecedingComments) {
            this.includePrecedingComments = includePrecedingComments;
            return this;
        }

        public YamlExtract withOriginalIndentation(boolean includeOriginalIndentation) {
            this.includeOriginalIndentation = includeOriginalIndentation;
            return this;
        }

        @Beta
        public String getMatchedYamlTextOrWarn() {
            try {
                return this.getMatchedYamlText();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal(e);
                if (e instanceof KnownClassVersionException) {
                    log.debug("Known class version exception; no yaml text being matched for " + this + ": " + e);
                } else if (e instanceof UserFacingException) {
                    log.warn("Unable to match yaml text in " + this + ": " + e.getMessage());
                } else {
                    log.warn("Unable to match yaml text in " + this + ": " + e, (Throwable)e);
                }
                return null;
            }
        }

        @Beta
        public String getMatchedYamlText() {
            String firstLineIndentationToAddS;
            if (!this.found()) {
                return null;
            }
            String[] body = this.yaml.substring(this.getStartOfThis(), this.getEndOfThis(true)).split("\n", -1);
            int firstLineIndentationOfFirstThing = this.focusTuple != null ? this.focusTuple.getKeyNode().getStartMark().getColumn() : this.focus.getStartMark().getColumn();
            int firstLineIndentationToAdd = this.focusTuple != null && (this.includeKey || body.length == 1) ? this.focusTuple.getKeyNode().getStartMark().getColumn() : this.focus.getStartMark().getColumn();
            String subsequentLineIndentationToRemoveS = firstLineIndentationToAddS = Strings.makePaddedString("", firstLineIndentationToAdd, "", " ");
            MutableList result = MutableList.of();
            if (this.includePrecedingComments) {
                if (this.getEndOfPrevious() > this.getStartOfThis()) {
                    throw new UserFacingException("YAML not in expected format; when scanning, previous end " + this.getEndOfPrevious() + " exceeds this start " + this.getStartOfThis());
                }
                String[] preceding = this.yaml.substring(this.getEndOfPrevious(), this.getStartOfThis()).split("\n");
                if (preceding.length > 0 && this.prev != null) {
                    preceding[0] = Strings.makePaddedString("", this.prev.getEndMark().getColumn(), "", " ") + preceding[0];
                }
                for (String p : preceding) {
                    int w = YamlExtract.initialWhitespaceLength(p);
                    if (!(p = p.substring(w)).startsWith("#") || w > firstLineIndentationOfFirstThing) continue;
                    if (this.includeOriginalIndentation) {
                        p = firstLineIndentationToAddS + p;
                    }
                    result.add(p);
                }
            }
            boolean doneFirst = false;
            for (String p : body) {
                if (!doneFirst) {
                    if (this.includeOriginalIndentation) {
                        p = firstLineIndentationToAddS + p;
                    }
                    result.add(p);
                    doneFirst = true;
                    continue;
                }
                if (this.includeOriginalIndentation) {
                    result.add(p);
                    continue;
                }
                result.add(Strings.removeFromStart(p, subsequentLineIndentationToRemoveS));
            }
            return Strings.join(result, "\n");
        }

        boolean found() {
            return this.focus != null;
        }

        public Exception getError() {
            return this.error;
        }

        public String toString() {
            return "Extract[" + this.focus + ";prev=" + this.prev + ";key=" + this.key + ";next=" + this.next + "]";
        }

        static class KnownClassVersionException
        extends IllegalStateException {
            private static final long serialVersionUID = -1620847775786753301L;

            public KnownClassVersionException(Throwable e) {
                super("Class version error. This can happen if using a TestNG plugin in your IDE which is an older version, dragging in an older version of SnakeYAML which does not support Mark.getIndex.", e);
            }
        }
    }

    private static class SafeConstructorExcludingNonNumbers
    extends SafeConstructor {
        public SafeConstructorExcludingNonNumbers(LoaderOptions loaderOptions) {
            super(loaderOptions);
            this.yamlConstructors.put(Tag.FLOAT, new ConstructYamlFloatExcludingNonNumbers());
        }

        class ConstructYamlFloatExcludingNonNumbers
        extends SafeConstructor.ConstructYamlFloat {
            ConstructYamlFloatExcludingNonNumbers() {
                super((SafeConstructor)SafeConstructorExcludingNonNumbers.this);
            }

            public Object construct(Node node) {
                return Yamls.numericDoublesOnly(super.construct(node), node);
            }
        }
    }

    private static class ConstructorExcludingNonNumbers
    extends Constructor {
        public ConstructorExcludingNonNumbers(LoaderOptions loaderOptions) {
            super(loaderOptions);
            this.yamlConstructors.put(Tag.FLOAT, new ConstructYamlFloatExcludingNonNumbers());
        }

        class ConstructYamlFloatExcludingNonNumbers
        extends SafeConstructor.ConstructYamlFloat {
            ConstructYamlFloatExcludingNonNumbers() {
                super((SafeConstructor)ConstructorExcludingNonNumbers.this);
            }

            public Object construct(Node node) {
                return Yamls.numericDoublesOnly(super.construct(node), node);
            }
        }
    }
}

