/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.riak;

import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.nosql.riak.RiakClusterImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Riak Cluster", description="Riak is a distributed NoSQL key-value data store that offers extremely high availability, fault tolerance, operational simplicity and scalability.", iconUrl="classpath://org/apache/brooklyn/entity/nosql/riak/riak.png")
@ImplementedBy(value=RiakClusterImpl.class)
public interface RiakCluster
extends DynamicCluster {
    public static final AttributeSensor<Map<Entity, String>> RIAK_CLUSTER_NODES = Sensors.newSensor((TypeToken)new TypeToken<Map<Entity, String>>(){}, (String)"riak.cluster.nodes", (String)"Names of all active Riak nodes in the cluster <Entity,Riak Name>");
    @SetFromFlag(value="delayBeforeAdvertisingCluster")
    public static final ConfigKey<Duration> DELAY_BEFORE_ADVERTISING_CLUSTER = ConfigKeys.newConfigKey(Duration.class, (String)"riak.cluster.delayBeforeAdvertisingCluster", (String)"Delay after cluster is started before checking and advertising its availability", (Object)Duration.seconds((Number)120));
    public static final AttributeSensor<Boolean> IS_CLUSTER_INIT = Sensors.newBooleanSensor((String)"riak.cluster.isClusterInit", (String)"Flag to determine if the cluster was already initialized");
    public static final AttributeSensor<Boolean> IS_FIRST_NODE_SET = Sensors.newBooleanSensor((String)"riak.cluster.isFirstNodeSet", (String)"Flag to determine if the first node has been set");
    public static final AttributeSensor<String> NODE_LIST = Sensors.newStringSensor((String)"riak.cluster.nodeList", (String)"List of nodes (including ports), comma separated");
    public static final AttributeSensor<String> NODE_LIST_PB_PORT = Sensors.newStringSensor((String)"riak.cluster.nodeListPbPort", (String)"List of nodes (including ports for riak db clients), comma separated");
    public static final AttributeSensor<URI> RIAK_CONSOLE_URI = Attributes.MAIN_URI;
    public static final AttributeSensor<Integer> NODE_GETS_1MIN_PER_NODE = Sensors.newIntegerSensor((String)"riak.node.gets.1m.perNode", (String)"Gets in the last minute, averaged across cluster");
    public static final AttributeSensor<Integer> NODE_PUTS_1MIN_PER_NODE = Sensors.newIntegerSensor((String)"riak.node.puts.1m.perNode", (String)"Puts in the last minute, averaged across cluster");
    public static final AttributeSensor<Integer> NODE_OPS_1MIN_PER_NODE = Sensors.newIntegerSensor((String)"riak.node.ops.1m.perNode", (String)"Sum of node gets and puts in the last minute, averaged across cluster");
}

