/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.geo;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.core.location.geo.HostGeoLookup;
import org.apache.brooklyn.util.net.Networking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GeoBytesHostGeoLookup
implements HostGeoLookup {
    public static final Logger log = LoggerFactory.getLogger(GeoBytesHostGeoLookup.class);
    private static boolean LOGGED_GEO_LOOKUP_UNAVAILABLE = false;

    public String getPropertiesLookupUrlForPublicIp(String ip) {
        return "http://www.geobytes.com/IpLocator.htm?GetLocation&template=valuepairs.txt&IpAddress=" + ip.trim();
    }

    public String getPropertiesLookupUrlForLocalhost() {
        return "http://www.geobytes.com/IpLocator.htm?GetLocation&template=valuepairs.txt";
    }

    public String getPropertiesLookupUrlFor(InetAddress address) {
        if (Networking.isPrivateSubnet((InetAddress)address)) {
            return this.getPropertiesLookupUrlForLocalhost();
        }
        return this.getPropertiesLookupUrlForPublicIp(address.getHostAddress());
    }

    @Override
    public HostGeoInfo getHostGeoInfo(InetAddress address) throws MalformedURLException, IOException {
        String url = this.getPropertiesLookupUrlFor(address);
        if (log.isDebugEnabled()) {
            log.debug("Geo info lookup for " + address + " at " + url);
        }
        Properties props = new Properties();
        try {
            props.load(new URL(url).openStream());
            HostGeoInfo geo = new HostGeoInfo(address.getHostName(), props.getProperty("city") + " (" + props.getProperty("iso2") + ")", Double.parseDouble(props.getProperty("latitude")), Double.parseDouble(props.getProperty("longitude")));
            log.info("Geo info lookup for " + address + " returned: " + geo);
            return geo;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Geo info lookup for " + address + " failed: " + e);
            }
            if (!LOGGED_GEO_LOOKUP_UNAVAILABLE) {
                LOGGED_GEO_LOOKUP_UNAVAILABLE = true;
                log.info("Geo info lookup unavailable (for " + address + "; cause " + e + ")");
            }
            return null;
        }
    }
}

