/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.api.AssemblyTemplateSpecInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampInternalUtils;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.text.Strings;

class CampResolver {
    private ManagementContext mgmt;
    private RegisteredType type;
    private RegisteredTypeLoadingContext context;

    public CampResolver(ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext context) {
        this.mgmt = mgmt;
        this.type = type;
        this.context = context;
    }

    public AbstractBrooklynObjectSpec<?, ?> createSpec() {
        return CampResolver.createSpecFromFull(this.mgmt, this.type, this.context.getExpectedJavaSuperType(), this.context.getAlreadyEncounteredTypes(), this.context.getLoader());
    }

    static AbstractBrooklynObjectSpec<?, ?> createSpecFromFull(ManagementContext mgmt, RegisteredType item, Class<?> expectedType, Set<String> parentEncounteredTypes, BrooklynClassLoadingContext loaderO) {
        PolicySpec<?> spec;
        BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext((ManagementContext)mgmt, (RegisteredType)item, (BrooklynClassLoadingContext)loaderO);
        ImmutableSet encounteredTypes = item.getSymbolicName() != null ? ImmutableSet.builder().addAll(parentEncounteredTypes).add((Object)item.getSymbolicName()).build() : parentEncounteredTypes;
        String planYaml = RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item);
        MutableSet supers = MutableSet.copyOf((Iterable)item.getSuperTypes());
        supers.addIfNotNull(expectedType);
        if (RegisteredTypes.isAnyTypeSubtypeOf((Set)supers, Policy.class)) {
            spec = CampInternalUtils.createPolicySpec(planYaml, loader, (Set<String>)encounteredTypes);
        } else if (RegisteredTypes.isAnyTypeSubtypeOf((Set)supers, Enricher.class)) {
            spec = CampInternalUtils.createEnricherSpec(planYaml, loader, (Set<String>)encounteredTypes);
        } else if (RegisteredTypes.isAnyTypeSubtypeOf((Set)supers, Location.class)) {
            spec = CampInternalUtils.createLocationSpec(planYaml, loader, (Set<String>)encounteredTypes);
        } else if (RegisteredTypes.isAnyTypeSubtypeOf((Set)supers, Application.class)) {
            spec = CampResolver.createEntitySpecFromServicesBlock(planYaml, loader, (Set<String>)encounteredTypes, true);
        } else if (RegisteredTypes.isAnyTypeSubtypeOf((Set)supers, Entity.class)) {
            spec = CampResolver.createEntitySpecFromServicesBlock(planYaml, loader, (Set<String>)encounteredTypes, false);
        } else {
            throw new IllegalStateException("Cannot detect spec type from " + item.getSuperTypes() + " for " + item + "\n" + planYaml);
        }
        if (expectedType != null && !expectedType.isAssignableFrom(spec.getType())) {
            throw new IllegalStateException("Creating spec from " + item + ", got " + spec.getType() + " which is incompatible with expected " + expectedType);
        }
        spec.stackCatalogItemId(item.getId());
        if (spec instanceof EntitySpec) {
            String name = spec.getDisplayName();
            Object defaultNameConf = spec.getConfig().get(AbstractEntity.DEFAULT_DISPLAY_NAME);
            Object defaultNameFlag = spec.getFlags().get(AbstractEntity.DEFAULT_DISPLAY_NAME.getName());
            if (Strings.isBlank((CharSequence)name) && defaultNameConf == null && defaultNameFlag == null) {
                spec.configure(AbstractEntity.DEFAULT_DISPLAY_NAME, (Object)item.getDisplayName());
            }
        } else if (Strings.isNonBlank((CharSequence)item.getDisplayName())) {
            spec.displayName(item.getDisplayName());
        }
        return spec;
    }

    private static EntitySpec<?> createEntitySpecFromServicesBlock(String plan, BrooklynClassLoadingContext loader, Set<String> encounteredTypes, boolean isApplication) {
        CampPlatform camp = CampInternalUtils.getCampPlatform(loader.getManagementContext());
        AssemblyTemplate at = CampInternalUtils.resolveDeploymentPlan(plan, loader, camp);
        AssemblyTemplateInstantiator instantiator = CampInternalUtils.getInstantiator(at);
        if (instantiator instanceof AssemblyTemplateSpecInstantiator) {
            EntitySpec<? extends Application> appSpec = ((AssemblyTemplateSpecInstantiator)instantiator).createApplicationSpec(at, camp, loader, encounteredTypes);
            if (!isApplication) {
                return EntityManagementUtils.unwrapEntity(appSpec);
            }
            return appSpec;
        }
        if (at.getPlatformComponentTemplates() == null || at.getPlatformComponentTemplates().isEmpty()) {
            throw new UnsupportedTypePlanException("No 'services' declared");
        }
        throw new IllegalStateException("Unable to instantiate YAML; invalid type or parameters in plan:\n" + plan);
    }
}

