/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_LocalNetworkGatewayProperties;
import org.jclouds.azurecompute.arm.domain.vpn.BGPSettings;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class LocalNetworkGatewayProperties
implements Provisionable {
    @Nullable
    public abstract BGPSettings bgpSettings();

    public abstract String gatewayIpAddress();

    @Nullable
    public abstract AddressSpace localNetworkAddressSpace();

    @Override
    @Nullable
    public abstract String provisioningState();

    @Nullable
    public abstract String resourceGuid();

    @SerializedNames(value={"bgpSettings", "gatewayIpAddress", "localNetworkAddressSpace", "provisioningState", "resourceGuid"})
    public static LocalNetworkGatewayProperties create(BGPSettings bgpSettings, String gatewayIpAddress, AddressSpace localNetworkAddressSpace, String provisioningState, String resourceGuid) {
        return LocalNetworkGatewayProperties.builder(gatewayIpAddress).bgpSettings(bgpSettings).localNetworkAddressSpace(localNetworkAddressSpace).provisioningState(provisioningState).resourceGuid(resourceGuid).build();
    }

    LocalNetworkGatewayProperties() {
    }

    public abstract Builder toBuilder();

    public static Builder builder(String gatewayIpAddress) {
        return new AutoValue_LocalNetworkGatewayProperties.Builder().gatewayIpAddress(gatewayIpAddress);
    }

    public static abstract class Builder {
        public abstract Builder bgpSettings(BGPSettings var1);

        public abstract Builder gatewayIpAddress(String var1);

        public abstract Builder localNetworkAddressSpace(AddressSpace var1);

        public abstract Builder provisioningState(String var1);

        public abstract Builder resourceGuid(String var1);

        public abstract LocalNetworkGatewayProperties build();
    }
}

