/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.azurecompute.arm.compute.domain.AutoValue_ResourceGroupAndName;

public abstract class ResourceGroupAndName {
    public abstract String resourceGroup();

    public abstract String name();

    protected ResourceGroupAndName() {
    }

    public static ResourceGroupAndName fromSlashEncoded(String id) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)id, (Object)"id"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"id must be in format resourcegroup/name");
        return new AutoValue_ResourceGroupAndName((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static ResourceGroupAndName fromResourceGroupAndName(String resourceGroup, String name) {
        return new AutoValue_ResourceGroupAndName(resourceGroup, name);
    }

    public String slashEncode() {
        return this.resourceGroup() + "/" + this.name();
    }
}

