/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import java.util.Map;

public class Utils {
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String str) {
        return !Utils.isNullOrEmpty(str);
    }

    public static String getProperty(Map<String, Object> properties, String propertyName, String defaultValue) {
        String answer = (String)properties.get(propertyName);
        if (!Utils.isNullOrEmpty(answer)) {
            return answer;
        }
        return Utils.getSystemPropertyOrEnvVar(propertyName, defaultValue);
    }

    public static String getProperty(Map<String, Object> properties, String propertyName) {
        return Utils.getProperty(properties, propertyName, null);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String envVarName, String defaultValue) {
        String answer = System.getProperty(systemPropertyName);
        if (Utils.isNotNullOrEmpty(answer)) {
            return answer;
        }
        answer = System.getenv(envVarName);
        if (Utils.isNotNullOrEmpty(answer)) {
            return answer;
        }
        return defaultValue;
    }

    public static String convertSystemPropertyNameToEnvVar(String systemPropertyName) {
        return systemPropertyName.toUpperCase().replaceAll("[.-]", "_");
    }

    public static String getEnvVar(String envVarName, String defaultValue) {
        String answer = System.getenv(envVarName);
        return Utils.isNotNullOrEmpty(answer) ? answer : defaultValue;
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String defaultValue) {
        return Utils.getSystemPropertyOrEnvVar(systemPropertyName, Utils.convertSystemPropertyNameToEnvVar(systemPropertyName), defaultValue);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName) {
        return Utils.getSystemPropertyOrEnvVar(systemPropertyName, (String)null);
    }

    public static Boolean getSystemPropertyOrEnvVar(String systemPropertyName, Boolean defaultValue) {
        String result = Utils.getSystemPropertyOrEnvVar(systemPropertyName, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static int getSystemPropertyOrEnvVar(String systemPropertyName, int defaultValue) {
        String result = Utils.getSystemPropertyOrEnvVar(systemPropertyName, new Integer(defaultValue).toString());
        return Integer.parseInt(result);
    }

    public static String join(Object[] array) {
        return Utils.join(array, ',');
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }
}

