/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.SoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.MachineLifecycleEffectorTasks;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.ReaderInputStream;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftwareProcessDriver
implements SoftwareProcessDriver {
    private static final Logger log = LoggerFactory.getLogger(AbstractSoftwareProcessDriver.class);
    protected final EntityLocal entity;
    protected final ResourceUtils resource;
    protected final Location location;
    private volatile String installDir;
    private volatile String runDir;
    private volatile String expandedInstallDir;
    private final Object installDirSetupMutex = new Object();

    public AbstractSoftwareProcessDriver(EntityLocal entity, Location location) {
        this.entity = (EntityLocal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.location = (Location)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.resource = ResourceUtils.create((Object)entity);
    }

    @Override
    public void rebind() {
    }

    @Override
    public void start() {
        boolean skipStart = false;
        Optional locationRunning = Optional.fromNullable((Object)this.getLocation().getConfig(BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING));
        Optional entityRunning = Optional.fromNullable((Object)this.entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING));
        Optional entityStarted = Optional.fromNullable((Object)this.entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START));
        skipStart = (Boolean)locationRunning.or(entityRunning).or((Object)false) != false ? this.isRunning() : ((Boolean)entityStarted.or((Object)false)).booleanValue();
        DynamicTasks.queue((String)"prepare", (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractSoftwareProcessDriver.this.prepare();
            }
        });
        if (!skipStart) {
            DynamicTasks.queue((String)"install", (Runnable)new Runnable(){

                @Override
                public void run() {
                    Optional entityInstalled;
                    Optional locationInstalled = Optional.fromNullable((Object)AbstractSoftwareProcessDriver.this.getLocation().getConfig(BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION));
                    boolean skipInstall = (Boolean)locationInstalled.or(entityInstalled = Optional.fromNullable((Object)AbstractSoftwareProcessDriver.this.entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION))).or((Object)false);
                    if (!skipInstall) {
                        DynamicTasks.queue((String)"copy-pre-install-resources", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.PRE_INSTALL_RESOURCES_LATCH);){
                                    AbstractSoftwareProcessDriver.this.copyPreInstallResources();
                                }
                            }
                        });
                        DynamicTasks.queue((String)"pre-install", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractSoftwareProcessDriver.this.preInstall();
                            }
                        });
                        DynamicTasks.queue((String)"pre-install-command", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractSoftwareProcessDriver.this.runPreInstallCommand();
                            }
                        });
                        DynamicTasks.queue((String)"setup", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.SETUP_LATCH);){
                                    AbstractSoftwareProcessDriver.this.setup();
                                }
                            }
                        });
                        DynamicTasks.queue((String)"copy-install-resources", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.INSTALL_RESOURCES_LATCH);){
                                    AbstractSoftwareProcessDriver.this.copyInstallResources();
                                }
                            }
                        });
                        DynamicTasks.queue((String)"install (main)", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.INSTALL_LATCH);){
                                    AbstractSoftwareProcessDriver.this.install();
                                }
                            }
                        });
                        DynamicTasks.queue((String)"post-install-command", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractSoftwareProcessDriver.this.runPostInstallCommand();
                            }
                        });
                    }
                }
            });
            DynamicTasks.queue((String)"customize", (Runnable)new Runnable(){

                @Override
                public void run() {
                    DynamicTasks.queue((String)"copy-pre-customize-resources", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.CUSTOMIZE_RESOURCES_LATCH);){
                                AbstractSoftwareProcessDriver.this.copyCustomizeResources();
                            }
                        }
                    });
                    DynamicTasks.queue((String)"pre-customize-command", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AbstractSoftwareProcessDriver.this.runPreCustomizeCommand();
                        }
                    });
                    DynamicTasks.queue((String)"customize (main)", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.CUSTOMIZE_LATCH);){
                                AbstractSoftwareProcessDriver.this.customize();
                            }
                        }
                    });
                    DynamicTasks.queue((String)"post-customize-command", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AbstractSoftwareProcessDriver.this.runPostCustomizeCommand();
                        }
                    });
                }
            });
            DynamicTasks.queue((String)"launch", (Runnable)new Runnable(){

                @Override
                public void run() {
                    DynamicTasks.queue((String)"copy-runtime-resources", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.RUNTIME_RESOURCES_LATCH);){
                                AbstractSoftwareProcessDriver.this.copyRuntimeResources();
                            }
                        }
                    });
                    DynamicTasks.queue((String)"pre-launch-command", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AbstractSoftwareProcessDriver.this.runPreLaunchCommand();
                        }
                    });
                    DynamicTasks.queue((String)"launch (main)", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try (MachineLifecycleEffectorTasks.CloseableLatch value = AbstractSoftwareProcessDriver.this.waitForLatch((ConfigKey<Boolean>)BrooklynConfigKeys.LAUNCH_LATCH);){
                                AbstractSoftwareProcessDriver.this.launch();
                            }
                        }
                    });
                    DynamicTasks.queue((String)"post-launch-command", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AbstractSoftwareProcessDriver.this.runPostLaunchCommand();
                        }
                    });
                }
            });
        }
        DynamicTasks.queue((String)"post-launch", (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractSoftwareProcessDriver.this.postLaunch();
            }
        });
    }

    private MachineLifecycleEffectorTasks.CloseableLatch waitForLatch(ConfigKey<Boolean> configKey) {
        return MachineLifecycleEffectorTasks.waitForCloseableLatch((Entity)((EntityInternal)this.entity), configKey);
    }

    @Override
    public abstract void stop();

    public void prepare() {
    }

    public void preInstall() {
    }

    public abstract void runPreInstallCommand();

    public abstract void setup();

    public abstract void install();

    public abstract void runPostInstallCommand();

    public abstract void runPreCustomizeCommand();

    public abstract void customize();

    public abstract void runPostCustomizeCommand();

    public abstract void runPreLaunchCommand();

    public abstract void launch();

    public abstract void runPostLaunchCommand();

    @Override
    public void kill() {
        this.stop();
    }

    public void postLaunch() {
    }

    @Override
    public void restart() {
        DynamicTasks.queue((String)"stop (best effort)", (Runnable)new Runnable(){

            @Override
            public void run() {
                DynamicTasks.markInessential();
                boolean previouslyRunning = AbstractSoftwareProcessDriver.this.isRunning();
                try {
                    ServiceStateLogic.setExpectedState((Entity)AbstractSoftwareProcessDriver.this.getEntity(), (Lifecycle)Lifecycle.STOPPING);
                    AbstractSoftwareProcessDriver.this.stop();
                }
                catch (Exception e) {
                    if (previouslyRunning) {
                        log.warn(AbstractSoftwareProcessDriver.this.getEntity() + " restart: stop failed, when was previously running (ignoring)", (Throwable)e);
                        DynamicTasks.queue((TaskAdaptable)Tasks.fail((String)"Primary job failure (when previously running)", (Throwable)e));
                    }
                    log.debug(AbstractSoftwareProcessDriver.this.getEntity() + " restart: stop failed (but was not previously running, so not a surprise)", (Throwable)e);
                    DynamicTasks.queue((TaskAdaptable)Tasks.fail((String)"Primary job failure (when not previously running)", (Throwable)e));
                }
            }
        });
        DynamicTasks.queue((String)"restart", (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractSoftwareProcessDriver.this.doFullStartOnRestart()) {
                        DynamicTasks.waitForLast();
                        ServiceStateLogic.setExpectedState((Entity)AbstractSoftwareProcessDriver.this.getEntity(), (Lifecycle)Lifecycle.STARTING);
                        AbstractSoftwareProcessDriver.this.start();
                    } else {
                        DynamicTasks.queue((String)"pre-launch-command", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ServiceStateLogic.setExpectedState((Entity)AbstractSoftwareProcessDriver.this.getEntity(), (Lifecycle)Lifecycle.STARTING);
                                AbstractSoftwareProcessDriver.this.runPreLaunchCommand();
                            }
                        });
                        DynamicTasks.queue((String)"launch (main)", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractSoftwareProcessDriver.this.launch();
                            }
                        });
                        DynamicTasks.queue((String)"post-launch-command", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractSoftwareProcessDriver.this.runPostLaunchCommand();
                            }
                        });
                        DynamicTasks.queue((String)"post-launch", (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractSoftwareProcessDriver.this.postLaunch();
                            }
                        });
                    }
                    DynamicTasks.waitForLast();
                }
                catch (Exception e) {
                    ServiceStateLogic.setExpectedState((Entity)AbstractSoftwareProcessDriver.this.entity, (Lifecycle)Lifecycle.ON_FIRE);
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    @Beta
    protected boolean doFullStartOnRestart() {
        return false;
    }

    @Override
    public EntityLocal getEntity() {
        return this.entity;
    }

    public Location getLocation() {
        return this.location;
    }

    public InputStream getResource(String url) {
        return this.resource.getResourceFromUrl(url);
    }

    public void copyPreInstallResources() {
        this.copyResources(this.getInstallDir(), (Map)this.entity.getConfig(SoftwareProcess.PRE_INSTALL_FILES), (Map)this.entity.getConfig(SoftwareProcess.PRE_INSTALL_TEMPLATES));
    }

    public void copyInstallResources() {
        this.copyResources(this.getInstallDir(), (Map)this.entity.getConfig(SoftwareProcess.INSTALL_FILES), (Map)this.entity.getConfig(SoftwareProcess.INSTALL_TEMPLATES));
    }

    public void copyCustomizeResources() {
        this.copyResources(this.getInstallDir(), (Map)this.entity.getConfig(SoftwareProcess.CUSTOMIZE_FILES), (Map)this.entity.getConfig(SoftwareProcess.CUSTOMIZE_TEMPLATES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResources(String destinationParentDir, Map<String, String> files, Map<String, String> templates) {
        if (files == null) {
            files = Collections.emptyMap();
        }
        if (templates == null) {
            templates = Collections.emptyMap();
        }
        ArrayList tasks = new ArrayList(files.size() + templates.size());
        this.applyFnToResourcesAppendToList(files, this.newCopyResourceFunction(), destinationParentDir, tasks);
        this.applyFnToResourcesAppendToList(templates, this.newCopyTemplateFunction(), destinationParentDir, tasks);
        if (!tasks.isEmpty()) {
            String oldBlockingDetails = Tasks.setBlockingDetails((String)"Copying resources");
            try {
                ((Task)DynamicTasks.queue((TaskAdaptable)Tasks.sequential(tasks))).getUnchecked();
            }
            finally {
                Tasks.setBlockingDetails((String)oldBlockingDetails);
            }
        }
    }

    protected String mergePaths(String ... s) {
        return Os.mergePathsUnix((String[])s);
    }

    private void applyFnToResourcesAppendToList(Map<String, String> resources, final Function<SourceAndDestination, Task<?>> function, String destinationParentDir, final List<TaskAdaptable<?>> tasks) {
        for (Map.Entry<String, String> entry : resources.entrySet()) {
            String source = (String)Preconditions.checkNotNull((Object)entry.getKey(), (Object)"Missing source for resource");
            String target = (String)Preconditions.checkNotNull((Object)entry.getValue(), (Object)"Missing destination for resource");
            final String destination = Os.isAbsolutish((String)target) ? target : this.mergePaths(destinationParentDir, target);
            File srcFile = new File(source);
            if (srcFile.isDirectory() && srcFile.exists()) {
                try {
                    Path start = srcFile.toPath();
                    final int startElements = start.getNameCount();
                    Files.walkFileTree(start, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isRegularFile()) {
                                Path relativePath = file.subpath(startElements, file.getNameCount());
                                tasks.add(function.apply((Object)new SourceAndDestination(file.toString(), AbstractSoftwareProcessDriver.this.mergePaths(destination, relativePath.toString()))));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            tasks.add((TaskAdaptable<?>)function.apply((Object)new SourceAndDestination(source, destination)));
        }
    }

    private Function<SourceAndDestination, Task<?>> newCopyResourceFunction() {
        return new Function<SourceAndDestination, Task<?>>(){

            public Task<?> apply(final SourceAndDestination input) {
                return Tasks.builder().displayName("Copying file: source=" + input.source + ", destination=" + input.destination).body((Callable)new Callable<Object>(){

                    @Override
                    public Integer call() {
                        return AbstractSoftwareProcessDriver.this.copyResource(input.source, input.destination, true);
                    }
                }).build();
            }
        };
    }

    private Function<SourceAndDestination, Task<?>> newCopyTemplateFunction() {
        return new Function<SourceAndDestination, Task<?>>(){

            public Task<?> apply(final SourceAndDestination input) {
                return Tasks.builder().displayName("Copying template: source=" + input.source + ", destination=" + input.destination).body((Callable)new Callable<Object>(){

                    @Override
                    public Integer call() {
                        Map substitutions = MutableMap.copyOf((Map)((Map)AbstractSoftwareProcessDriver.this.entity.config().get(SoftwareProcess.TEMPLATE_SUBSTITUTIONS))).asUnmodifiable();
                        return AbstractSoftwareProcessDriver.this.copyTemplate(input.source, input.destination, true, substitutions);
                    }
                }).build();
            }
        };
    }

    protected abstract void createDirectory(String var1, String var2);

    public void copyRuntimeResources() {
        try {
            this.copyResources(this.getRunDir(), (Map)this.entity.getConfig(SoftwareProcess.RUNTIME_FILES), (Map)this.entity.getConfig(SoftwareProcess.RUNTIME_TEMPLATES));
        }
        catch (Exception e) {
            log.warn("Error copying runtime resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public int copyTemplate(File template, String target) {
        return this.copyTemplate(template.toURI().toASCIIString(), target);
    }

    public int copyTemplate(String template, String target) {
        return this.copyTemplate(template, target, false, (Map<String, ?>)ImmutableMap.of());
    }

    public int copyTemplate(String templateUrl, String target, boolean createParent, Map<String, ?> extraSubstitutions) {
        log.debug("Processing template " + templateUrl + " and copying to " + target + " on " + this.getLocation() + " for " + this.getEntity());
        String data = this.processTemplate(templateUrl, extraSubstitutions);
        return this.copyResource((Map<Object, Object>)MutableMap.of(), new StringReader(data), target, createParent);
    }

    public abstract int copyResource(Map<Object, Object> var1, String var2, String var3, boolean var4);

    public abstract int copyResource(Map<Object, Object> var1, InputStream var2, String var3, boolean var4);

    public int copyResource(File file, String target) {
        return this.copyResource(file.toURI().toASCIIString(), target);
    }

    public int copyResource(String resource, String target) {
        return this.copyResource((Map)MutableMap.of(), resource, target);
    }

    public int copyResource(String resourceUrl, String target, boolean createParentDir) {
        return this.copyResource((Map<Object, Object>)MutableMap.of(), resourceUrl, target, createParentDir);
    }

    public int copyResource(Map sshFlags, String source, String target) {
        return this.copyResource((Map<Object, Object>)sshFlags, source, target, false);
    }

    public int copyResource(Reader source, String target) {
        return this.copyResource((Map<Object, Object>)MutableMap.of(), source, target, false);
    }

    public int copyResource(Map<Object, Object> sshFlags, Reader source, String target, boolean createParent) {
        return this.copyResource(sshFlags, (InputStream)new ReaderInputStream(source), target, createParent);
    }

    public int copyResource(InputStream source, String target) {
        return this.copyResource((Map<Object, Object>)MutableMap.of(), source, target, false);
    }

    public String getResourceAsString(String url) {
        return this.resource.getResourceAsString(url);
    }

    public String processTemplate(File templateConfigFile, Map<String, Object> extraSubstitutions) {
        return this.processTemplate(templateConfigFile.toURI().toASCIIString(), extraSubstitutions);
    }

    public String processTemplate(File templateConfigFile) {
        return this.processTemplate(templateConfigFile.toURI().toASCIIString());
    }

    public String processTemplate(String templateConfigUrl) {
        return this.processTemplate(templateConfigUrl, (Map<String, ? extends Object>)ImmutableMap.of());
    }

    public String processTemplate(String templateConfigUrl, Map<String, ? extends Object> extraSubstitutions) {
        return this.processTemplateContents(this.getResourceAsString(templateConfigUrl), extraSubstitutions);
    }

    public String processTemplateContents(String templateContents) {
        return this.processTemplateContents(templateContents, (Map<String, ? extends Object>)ImmutableMap.of());
    }

    public String processTemplateContents(String templateContents, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents((String)templateContents, (EntityDriver)this, extraSubstitutions);
    }

    public String getArchiveNameFormat() {
        return (String)this.getEntity().config().get(SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT);
    }

    public String getVersion() {
        return (String)this.getEntity().config().get(SoftwareProcess.SUGGESTED_VERSION);
    }

    public Map<String, String> getShellEnvironment() {
        Map env = (Map)this.entity.getConfig(SoftwareProcess.SHELL_ENVIRONMENT);
        ShellEnvironmentSerializer envSerializer = new ShellEnvironmentSerializer(((EntityInternal)this.entity).getManagementContext());
        return envSerializer.serialize(env);
    }

    protected void setInstallDir(String installDir) {
        this.installDir = installDir;
        this.entity.sensors().set(SoftwareProcess.INSTALL_DIR, (Object)installDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstallDir() {
        if (this.installDir != null) {
            return this.installDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.installDir = existingVal;
            return this.installDir;
        }
        Object object = this.installDirSetupMutex;
        synchronized (object) {
            this.setInstallLabel();
            this.setInstallDir(null);
            this.setInstallDir(Os.tidyPath((String)((String)ConfigToAttributes.apply((Entity)this.getEntity(), SoftwareProcess.INSTALL_DIR))));
            return this.installDir;
        }
    }

    protected void setInstallLabel() {
        if (((EntityInternal)this.getEntity()).config().getLocalRaw(SoftwareProcess.INSTALL_UNIQUE_LABEL).isPresentAndNonNull()) {
            return;
        }
        this.getEntity().config().set(SoftwareProcess.INSTALL_UNIQUE_LABEL, (Object)(this.getEntity().getEntityType().getSimpleName() + (Strings.isNonBlank((CharSequence)this.getVersion()) ? "_" + this.getVersion() : "") + (Strings.isNonBlank((CharSequence)this.getInstallLabelExtraSalt()) ? "_" + this.getInstallLabelExtraSalt() : "")));
    }

    protected String getInstallLabelExtraSalt() {
        return null;
    }

    protected void setRunDir(String runDir) {
        this.runDir = runDir;
        this.entity.sensors().set(SoftwareProcess.RUN_DIR, (Object)runDir);
    }

    public String getRunDir() {
        if (this.runDir != null) {
            return this.runDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.RUN_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.runDir = existingVal;
            return this.runDir;
        }
        this.setRunDir(Os.tidyPath((String)((String)ConfigToAttributes.apply((Entity)this.getEntity(), SoftwareProcess.RUN_DIR))));
        return this.runDir;
    }

    public void setExpandedInstallDir(String val) {
        String oldVal = (String)this.getEntity().getAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)oldVal) && !oldVal.equals(val)) {
            log.info("Resetting expandedInstallDir (to " + val + " from " + oldVal + ") for " + this.getEntity());
        }
        this.expandedInstallDir = val;
        this.getEntity().sensors().set(SoftwareProcess.EXPANDED_INSTALL_DIR, (Object)val);
    }

    public String getExpandedInstallDir() {
        if (this.expandedInstallDir != null) {
            return this.expandedInstallDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.expandedInstallDir = existingVal;
            return this.expandedInstallDir;
        }
        String untidiedVal = (String)ConfigToAttributes.apply((Entity)this.getEntity(), SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)untidiedVal)) {
            this.setExpandedInstallDir(Os.tidyPath((String)untidiedVal));
            return this.expandedInstallDir;
        }
        throw new IllegalStateException("expandedInstallDir is null; most likely install was not called for " + this.getEntity());
    }

    private static class SourceAndDestination {
        final String source;
        final String destination;

        private SourceAndDestination(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }
    }
}

