/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.domain.Device;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.internal.PaginatedCollection;
import org.jclouds.packet.domain.options.ListOptions;
import org.jclouds.packet.filters.AddApiVersionToRequest;
import org.jclouds.packet.filters.AddXAuthTokenToRequest;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
@RequestFilters(value={AddXAuthTokenToRequest.class, AddApiVersionToRequest.class})
public interface DeviceApi {
    @Named(value="device:list")
    @GET
    @Path(value="/projects/{projectId}/devices")
    @ResponseParser(value=ParseDevices.class)
    @Transform(value=ParseDevices.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Device> list();

    @Named(value="device:list")
    @GET
    @Path(value="/projects/{projectId}/devices")
    @ResponseParser(value=ParseDevices.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Device> list(ListOptions var1);

    @Named(value="device:create")
    @POST
    @Path(value="/projects/{projectId}/devices")
    @Produces(value={"application/json"})
    public Device create(@BinderParam(value=BindToJsonPayload.class) Device.CreateDevice var1);

    @Named(value="device:get")
    @GET
    @Path(value="/devices/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Device get(@PathParam(value="id") String var1);

    @Named(value="device:delete")
    @DELETE
    @Path(value="/devices/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") String var1);

    @Named(value="device:powerOff")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/devices/{id}/actions")
    @Payload(value="{\"type\":\"power_off\"}")
    public void powerOff(@PathParam(value="id") String var1);

    @Named(value="device:powerOn")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/devices/{id}/actions")
    @Payload(value="{\"type\":\"power_on\"}")
    public void powerOn(@PathParam(value="id") String var1);

    @Named(value="device:reboot")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/devices/{id}/actions")
    @Payload(value="{\"type\":\"reboot\"}")
    public void reboot(@PathParam(value="id") String var1);

    public static final class ParseDevices
    extends ParseJson<Devices> {
        @Inject
        ParseDevices(Json json) {
            super(json, TypeLiteral.get(Devices.class));
        }

        public static class ToPagedIterable
        extends Arg0ToPagedIterable.FromCaller<Device, ToPagedIterable> {
            private final PacketApi api;
            private final Function<Href, ListOptions> hrefToOptions;

            @Inject
            ToPagedIterable(PacketApi api, Function<Href, ListOptions> hrefToOptions) {
                this.api = api;
                this.hrefToOptions = hrefToOptions;
            }

            protected Function<Object, IterableWithMarker<Device>> markerToNextForArg0(Optional<Object> arg0) {
                String projectId = arg0.get().toString();
                final DeviceApi deviceApi = this.api.deviceApi(projectId);
                return new Function<Object, IterableWithMarker<Device>>(){

                    public IterableWithMarker<Device> apply(Object input) {
                        ListOptions listOptions = (ListOptions)((Object)ToPagedIterable.this.hrefToOptions.apply(Href.class.cast(input)));
                        return (IterableWithMarker)IterableWithMarker.class.cast(deviceApi.list(listOptions));
                    }
                };
            }
        }

        private static class Devices
        extends PaginatedCollection<Device> {
            @ConstructorProperties(value={"devices", "meta"})
            public Devices(List<Device> items, PaginatedCollection.Meta meta) {
                super(items, meta);
            }
        }
    }
}

