/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.collect.ForwardingObject;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.json.Json;

@Singleton
public class GsonWrapper
extends ForwardingObject
implements Json {
    private final Gson gson;

    @Inject
    public GsonWrapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T fromJson(String json, Type type) {
        return (T)this.gson.fromJson(json, type);
    }

    @Override
    public <T> T fromJson(String json, Class<T> classOfT) {
        return (T)this.gson.fromJson(json, classOfT);
    }

    @Override
    public <T> T fromJson(InputStream json, Type type) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(json), type);
    }

    @Override
    public <T> T fromJson(InputStream json, Class<T> classOfT) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(json), classOfT);
    }

    @Override
    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    @Override
    public String toJson(Object src, Type type) {
        return this.gson.toJson(src, type);
    }

    public Gson delegate() {
        return this.gson;
    }
}

