/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.text.Strings;

public class StringFunctions {
    @Deprecated
    private static Function<String, String> appendOld(final String suffix) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                return input + suffix;
            }
        };
    }

    @Deprecated
    private static Function<String, String> prependOld(final String prefix) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                return prefix + input;
            }
        };
    }

    @Deprecated
    private static Function<Object, String> formatterOld(final String pattern) {
        return new Function<Object, String>(){

            public String apply(@Nullable Object input) {
                return String.format(pattern, input);
            }
        };
    }

    @Deprecated
    private static Function<Object[], String> formatterForArrayOld(final String pattern) {
        return new Function<Object[], String>(){

            public String apply(@Nullable Object[] input) {
                return String.format(pattern, input);
            }
        };
    }

    @Deprecated
    private static Function<Iterable<?>, String> joinerOld(final String separator) {
        return new Function<Iterable<?>, String>(){

            public String apply(@Nullable Iterable<?> input) {
                return Strings.join(input, separator);
            }
        };
    }

    @Deprecated
    private static Function<Object[], String> joinerForArrayOld(final String separator) {
        return new Function<Object[], String>(){

            public String apply(@Nullable Object[] input) {
                if (input == null) {
                    return "";
                }
                return Strings.join(input, separator);
            }
        };
    }

    @Deprecated
    private static Function<String, Integer> lengthOld() {
        return new Function<String, Integer>(){

            public Integer apply(@Nullable String input) {
                if (input == null) {
                    return -1;
                }
                return input.length();
            }
        };
    }

    @Deprecated
    private static Function<String, String> surroundOld(final String prefix, final String suffix) {
        return new Function<String, String>(){

            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                return prefix + input + suffix;
            }
        };
    }

    @Deprecated
    private static Function<String, String> trimOld() {
        return new Function<String, String>(){

            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                if (Strings.isBlank(input)) {
                    return "";
                }
                return CharMatcher.BREAKING_WHITESPACE.trimFrom((CharSequence)input);
            }
        };
    }

    @Deprecated
    private static Function<String, String> toLowerCaseOld() {
        return new Function<String, String>(){

            public String apply(String input) {
                return input.toLowerCase();
            }
        };
    }

    @Deprecated
    private static Function<String, String> toUpperCaseOld() {
        return new Function<String, String>(){

            public String apply(String input) {
                return input.toUpperCase();
            }
        };
    }

    @Deprecated
    private static Function<String, String> convertCaseOld(final CaseFormat src, final CaseFormat target) {
        return new Function<String, String>(){

            public String apply(String input) {
                return src.to(target, input);
            }
        };
    }

    public static Function<String, String> append(String suffix) {
        return new AppendFunction((String)Preconditions.checkNotNull((Object)suffix, (Object)"suffix"));
    }

    public static Function<String, String> prepend(String prefix) {
        return new PrependFunction((String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix"));
    }

    public static Function<Object, String> formatter(String pattern) {
        return new FormatterFunction(pattern);
    }

    public static Function<Object[], String> formatterForArray(String pattern) {
        return new FormatterForArrayFunction((String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern"));
    }

    public static Function<Iterable<?>, String> formatterForIterable(String pattern) {
        return new FormatterForIterableFunction(pattern);
    }

    public static Function<Iterable<?>, String> joiner(String separator) {
        return new JoinerFunction(separator);
    }

    public static Function<Object[], String> joinerForArray(String separator) {
        return new JoinerForArrayFunction((String)Preconditions.checkNotNull((Object)separator, (Object)"separator"));
    }

    public static Function<Object, String> toStringFunction() {
        return Functions.toStringFunction();
    }

    public static Function<String, Integer> length() {
        return new LengthFunction();
    }

    public static Function<String, String> surround(String prefix, String suffix) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)suffix);
        return new SurroundFunction(prefix, suffix);
    }

    public static Function<String, String> trim() {
        return new TrimFunction();
    }

    public static Function<String, String> trimEnd() {
        return new TrimEndFunction();
    }

    public static Function<String, String> toLowerCase() {
        return new LowerCaseFunction();
    }

    public static Function<String, String> toUpperCase() {
        return new UpperCaseFunction();
    }

    public static Function<String, String> convertCase(CaseFormat src, CaseFormat target) {
        return new ConvertCaseFunction((CaseFormat)Preconditions.checkNotNull((Object)src, (Object)"src"), (CaseFormat)Preconditions.checkNotNull((Object)target, (Object)"target"));
    }

    public static class RegexReplacer
    implements Function<String, String> {
        private final String pattern;
        private final String replacement;

        public RegexReplacer(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Nullable
        public String apply(@Nullable String s) {
            return s == null ? null : Strings.replaceAllRegex(s, this.pattern, this.replacement);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.pattern, this.replacement});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RegexReplacer that = (RegexReplacer)RegexReplacer.class.cast(obj);
            return Objects.equal((Object)this.pattern, (Object)that.pattern) && Objects.equal((Object)this.replacement, (Object)that.replacement);
        }
    }

    protected static class ConvertCaseFunction
    implements Function<String, String> {
        private final CaseFormat src;
        private final CaseFormat target;

        public ConvertCaseFunction(CaseFormat src, CaseFormat target) {
            this.src = src;
            this.target = target;
        }

        public String apply(String input) {
            return this.src.to(this.target, input);
        }
    }

    protected static class UpperCaseFunction
    implements Function<String, String> {
        protected UpperCaseFunction() {
        }

        public String apply(String input) {
            return input.toUpperCase();
        }
    }

    protected static class LowerCaseFunction
    implements Function<String, String> {
        protected LowerCaseFunction() {
        }

        public String apply(String input) {
            return input.toLowerCase();
        }
    }

    protected static class TrimEndFunction
    implements Function<String, String> {
        protected TrimEndFunction() {
        }

        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return Strings.trimEnd(input);
        }
    }

    protected static class TrimFunction
    implements Function<String, String> {
        protected TrimFunction() {
        }

        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            if (Strings.isBlank(input)) {
                return "";
            }
            return CharMatcher.BREAKING_WHITESPACE.trimFrom((CharSequence)input);
        }
    }

    protected static class SurroundFunction
    implements Function<String, String> {
        private final String prefix;
        private final String suffix;

        public SurroundFunction(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return this.prefix + input + this.suffix;
        }
    }

    protected static class LengthFunction
    implements Function<String, Integer> {
        protected LengthFunction() {
        }

        public Integer apply(@Nullable String input) {
            if (input == null) {
                return -1;
            }
            return input.length();
        }
    }

    private static class JoinerForArrayFunction
    implements Function<Object[], String> {
        private final String separator;

        protected JoinerForArrayFunction(String separator) {
            this.separator = separator;
        }

        public String apply(@Nullable Object[] input) {
            if (input == null) {
                return "";
            }
            return Strings.join(input, this.separator);
        }
    }

    private static class JoinerFunction
    implements Function<Iterable<?>, String> {
        private final String separator;

        public JoinerFunction(String separator) {
            this.separator = separator;
        }

        public String apply(@Nullable Iterable<?> input) {
            return Strings.join(input, this.separator);
        }
    }

    protected static class FormatterForIterableFunction
    implements Function<Iterable<?>, String> {
        final String pattern;

        public FormatterForIterableFunction(String pattern) {
            this.pattern = pattern;
        }

        public String apply(@Nullable Iterable<?> input) {
            Object[] arr = input == null ? null : Iterables.toArray(input, Object.class);
            return String.format(this.pattern, arr);
        }
    }

    protected static class FormatterForArrayFunction
    implements Function<Object[], String> {
        private final String pattern;

        public FormatterForArrayFunction(String pattern) {
            this.pattern = pattern;
        }

        public String apply(@Nullable Object[] input) {
            return String.format(this.pattern, input);
        }
    }

    protected static class FormatterFunction
    implements Function<Object, String> {
        private final String pattern;

        FormatterFunction(String pattern) {
            this.pattern = pattern;
        }

        public String apply(@Nullable Object input) {
            return String.format(this.pattern, input);
        }
    }

    protected static class PrependFunction
    implements Function<String, String> {
        private final String prefix;

        public PrependFunction(String prefix) {
            this.prefix = prefix;
        }

        @Nullable
        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return this.prefix + input;
        }
    }

    private static class AppendFunction
    implements Function<String, String> {
        private final String suffix;

        public AppendFunction(String suffix) {
            this.suffix = suffix;
        }

        @Nullable
        public String apply(@Nullable String input) {
            if (input == null) {
                return null;
            }
            return input + this.suffix;
        }
    }
}

